/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * HrisJobValue
 * 
 * <p>The status of the job.
 */
@JsonDeserialize(using = HrisJobValue._Deserializer.class)
@JsonSerialize(using = HrisJobValue._Serializer.class)
public class HrisJobValue {

    public static final HrisJobValue DRAFT = new HrisJobValue("draft");
    public static final HrisJobValue PENDING = new HrisJobValue("pending");
    public static final HrisJobValue ARCHIVED = new HrisJobValue("archived");
    public static final HrisJobValue CLOSED = new HrisJobValue("closed");
    public static final HrisJobValue OPEN = new HrisJobValue("open");
    public static final HrisJobValue DELETED = new HrisJobValue("deleted");
    public static final HrisJobValue UNMAPPED_VALUE = new HrisJobValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HrisJobValue> values = createValuesMap();
    private static final Map<String, HrisJobValueEnum> enums = createEnumsMap();

    private final String value;

    private HrisJobValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HrisJobValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HrisJobValue
     */ 
    public static HrisJobValue of(String value) {
        synchronized (HrisJobValue.class) {
            return values.computeIfAbsent(value, v -> new HrisJobValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<HrisJobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HrisJobValue other = (HrisJobValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HrisJobValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HrisJobValue[] values() {
        synchronized (HrisJobValue.class) {
            return values.values().toArray(new HrisJobValue[] {});
        }
    }

    private static final Map<String, HrisJobValue> createValuesMap() {
        Map<String, HrisJobValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisJobValueEnum> createEnumsMap() {
        Map<String, HrisJobValueEnum> map = new HashMap<>();
        map.put("draft", HrisJobValueEnum.DRAFT);
        map.put("pending", HrisJobValueEnum.PENDING);
        map.put("archived", HrisJobValueEnum.ARCHIVED);
        map.put("closed", HrisJobValueEnum.CLOSED);
        map.put("open", HrisJobValueEnum.OPEN);
        map.put("deleted", HrisJobValueEnum.DELETED);
        map.put("unmapped_value", HrisJobValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<HrisJobValue> {

        protected _Serializer() {
            super(HrisJobValue.class);
        }

        @Override
        public void serialize(HrisJobValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<HrisJobValue> {

        protected _Deserializer() {
            super(HrisJobValue.class);
        }

        @Override
        public HrisJobValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return HrisJobValue.of(v);
        }
    }
    
    public enum HrisJobValueEnum {

        DRAFT("draft"),
        PENDING("pending"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HrisJobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

