/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AccountingListCompaniesRequest;
import com.stackone.stackone_client_java.models.operations.AccountingListCompaniesResponse;
import com.stackone.stackone_client_java.operations.AccountingListCompanies;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AccountingListCompaniesRequestBuilder {
    private AccountingListCompaniesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AccountingListCompaniesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingListCompaniesRequestBuilder request(AccountingListCompaniesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AccountingListCompaniesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingListCompaniesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AccountingListCompaniesResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanies.Sync operation = new AccountingListCompanies.Sync(this.sdkConfiguration, options, this._headers);
        return (AccountingListCompaniesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AccountingListCompaniesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanies.Sync operation = new AccountingListCompanies.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AccountingListCompaniesRequest, String> iterator = new Paginator<AccountingListCompaniesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AccountingListCompaniesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AccountingListCompaniesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

