/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsJobsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListJobsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AtsJobsPaginated> atsJobsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListJobsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AtsJobsPaginated> atsJobsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsJobsPaginated, "atsJobsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsJobsPaginated = atsJobsPaginated;
        this.headers = headers;
    }

    public AtsListJobsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AtsJobsPaginated> atsJobsPaginated() {
        return this.atsJobsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListJobsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListJobsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListJobsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListJobsResponse withAtsJobsPaginated(AtsJobsPaginated atsJobsPaginated) {
        Utils.checkNotNull(atsJobsPaginated, "atsJobsPaginated");
        this.atsJobsPaginated = Optional.ofNullable(atsJobsPaginated);
        return this;
    }

    public AtsListJobsResponse withAtsJobsPaginated(Optional<? extends AtsJobsPaginated> atsJobsPaginated) {
        Utils.checkNotNull(atsJobsPaginated, "atsJobsPaginated");
        this.atsJobsPaginated = atsJobsPaginated;
        return this;
    }

    public AtsListJobsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListJobsResponse other = (AtsListJobsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.atsJobsPaginated, other.atsJobsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.atsJobsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListJobsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsJobsPaginated", this.atsJobsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AtsJobsPaginated> atsJobsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsJobsPaginated(AtsJobsPaginated atsJobsPaginated) {
            Utils.checkNotNull(atsJobsPaginated, "atsJobsPaginated");
            this.atsJobsPaginated = Optional.ofNullable(atsJobsPaginated);
            return this;
        }

        public Builder atsJobsPaginated(Optional<? extends AtsJobsPaginated> atsJobsPaginated) {
            Utils.checkNotNull(atsJobsPaginated, "atsJobsPaginated");
            this.atsJobsPaginated = atsJobsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListJobsResponse build() {
            return new AtsListJobsResponse(this.contentType, this.statusCode, this.rawResponse, this.atsJobsPaginated, this.headers);
        }
    }
}

