/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WorkEligibilityResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetEmployeesWorkEligibilityResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends WorkEligibilityResult> workEligibilityResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetEmployeesWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends WorkEligibilityResult> workEligibilityResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workEligibilityResult = workEligibilityResult;
        this.headers = headers;
    }

    public HrisGetEmployeesWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkEligibilityResult> workEligibilityResult() {
        return this.workEligibilityResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetEmployeesWorkEligibilityResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withWorkEligibilityResult(WorkEligibilityResult workEligibilityResult) {
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        this.workEligibilityResult = Optional.ofNullable(workEligibilityResult);
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withWorkEligibilityResult(Optional<? extends WorkEligibilityResult> workEligibilityResult) {
        Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
        this.workEligibilityResult = workEligibilityResult;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeesWorkEligibilityResponse other = (HrisGetEmployeesWorkEligibilityResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.workEligibilityResult, other.workEligibilityResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetEmployeesWorkEligibilityResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workEligibilityResult", this.workEligibilityResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends WorkEligibilityResult> workEligibilityResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workEligibilityResult(WorkEligibilityResult workEligibilityResult) {
            Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
            this.workEligibilityResult = Optional.ofNullable(workEligibilityResult);
            return this;
        }

        public Builder workEligibilityResult(Optional<? extends WorkEligibilityResult> workEligibilityResult) {
            Utils.checkNotNull(workEligibilityResult, "workEligibilityResult");
            this.workEligibilityResult = workEligibilityResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetEmployeesWorkEligibilityResponse build() {
            return new HrisGetEmployeesWorkEligibilityResponse(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityResult, this.headers);
        }
    }
}

