/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListConnectorsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListConnectorsMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneGetConnectorMeta;
import com.stackone.stackone_client_java.operations.StackoneListConnectorsMeta;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Retrieve metadata for connectors.
 */
public class AsyncConnectors {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Connectors syncSDK;

    AsyncConnectors(Connectors syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Connectors sync() {
        return syncSDK;
    }


    /**
     * List Connector Meta Information
     * 
     * @return The async call builder
     */
    public StackoneListConnectorsMetaRequestBuilder listConnectorsMeta() {
        return new StackoneListConnectorsMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * List Connector Meta Information
     * 
     * @return {@code CompletableFuture<StackoneListConnectorsMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneListConnectorsMetaResponse> listConnectorsMetaDirect() {
        return listConnectorsMeta(JsonNullable.undefined(), Optional.empty());
    }

    /**
     * List Connector Meta Information
     * 
     * @param include The comma separated list of data that will be included in the response
     * @param options additional options
     * @return {@code CompletableFuture<StackoneListConnectorsMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneListConnectorsMetaResponse> listConnectorsMeta(JsonNullable<String> include, Optional<Options> options) {
        StackoneListConnectorsMetaRequest request =
            StackoneListConnectorsMetaRequest
                .builder()
                .include(include)
                .build();
        AsyncRequestOperation<StackoneListConnectorsMetaRequest, StackoneListConnectorsMetaResponse> operation
              = new StackoneListConnectorsMeta.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Connector Meta Information
     * 
     * @return The async call builder
     */
    public StackoneGetConnectorMetaRequestBuilder getConnectorMeta() {
        return new StackoneGetConnectorMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Connector Meta Information
     * 
     * @param provider 
     * @return {@code CompletableFuture<StackoneGetConnectorMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneGetConnectorMetaResponse> getConnectorMeta(String provider) {
        return getConnectorMeta(provider, JsonNullable.undefined(), Optional.empty());
    }

    /**
     * Get Connector Meta Information
     * 
     * @param provider 
     * @param include The comma separated list of data that will be included in the response
     * @param options additional options
     * @return {@code CompletableFuture<StackoneGetConnectorMetaResponse>} - The async response
     */
    public CompletableFuture<StackoneGetConnectorMetaResponse> getConnectorMeta(
            String provider, JsonNullable<String> include,
            Optional<Options> options) {
        StackoneGetConnectorMetaRequest request =
            StackoneGetConnectorMetaRequest
                .builder()
                .provider(provider)
                .include(include)
                .build();
        AsyncRequestOperation<StackoneGetConnectorMetaRequest, StackoneGetConnectorMetaResponse> operation
              = new StackoneGetConnectorMeta.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
