/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TicketingTicketStatusValue {
    public static final TicketingTicketStatusValue TO_DO = new TicketingTicketStatusValue("to-do");
    public static final TicketingTicketStatusValue IN_PROGRESS = new TicketingTicketStatusValue("in-progress");
    public static final TicketingTicketStatusValue CLOSED = new TicketingTicketStatusValue("closed");
    public static final TicketingTicketStatusValue UNMAPPED_VALUE = new TicketingTicketStatusValue("unmapped_value");
    private static final Map<String, TicketingTicketStatusValue> values = TicketingTicketStatusValue.createValuesMap();
    private static final Map<String, TicketingTicketStatusValueEnum> enums = TicketingTicketStatusValue.createEnumsMap();
    private final String value;

    private TicketingTicketStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingTicketStatusValue of(String value) {
        Class<TicketingTicketStatusValue> clazz = TicketingTicketStatusValue.class;
        synchronized (TicketingTicketStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingTicketStatusValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TicketingTicketStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingTicketStatusValue other = (TicketingTicketStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingTicketStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingTicketStatusValue[] values() {
        Class<TicketingTicketStatusValue> clazz = TicketingTicketStatusValue.class;
        synchronized (TicketingTicketStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingTicketStatusValue[0]);
        }
    }

    private static final Map<String, TicketingTicketStatusValue> createValuesMap() {
        LinkedHashMap<String, TicketingTicketStatusValue> map = new LinkedHashMap<String, TicketingTicketStatusValue>();
        map.put("to-do", TO_DO);
        map.put("in-progress", IN_PROGRESS);
        map.put("closed", CLOSED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingTicketStatusValueEnum> createEnumsMap() {
        HashMap<String, TicketingTicketStatusValueEnum> map = new HashMap<String, TicketingTicketStatusValueEnum>();
        map.put("to-do", TicketingTicketStatusValueEnum.TO_DO);
        map.put("in-progress", TicketingTicketStatusValueEnum.IN_PROGRESS);
        map.put("closed", TicketingTicketStatusValueEnum.CLOSED);
        map.put("unmapped_value", TicketingTicketStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingTicketStatusValueEnum {
        TO_DO("to-do"),
        IN_PROGRESS("in-progress"),
        CLOSED("closed"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingTicketStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TicketingTicketStatusValue> {
        protected _Deserializer() {
            super(TicketingTicketStatusValue.class);
        }

        public TicketingTicketStatusValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TicketingTicketStatusValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TicketingTicketStatusValue> {
        protected _Serializer() {
            super(TicketingTicketStatusValue.class);
        }

        public void serialize(TicketingTicketStatusValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

