/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * MessageMessageType
 * 
 * <p>Stackone enum identifying the type of message associated with the content.
 */
public class MessageMessageType {
    /**
     * The unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends MessageValue> value;

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends MessageSourceValue> sourceValue;

    @JsonCreator
    public MessageMessageType(
            @JsonProperty("value") JsonNullable<? extends MessageValue> value,
            @JsonProperty("source_value") JsonNullable<? extends MessageSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public MessageMessageType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessageValue> value() {
        return (JsonNullable<MessageValue>) value;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessageSourceValue> sourceValue() {
        return (JsonNullable<MessageSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unified message type.
     */
    public MessageMessageType withValue(MessageValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified message type.
     */
    public MessageMessageType withValue(JsonNullable<? extends MessageValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public MessageMessageType withSourceValue(MessageSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public MessageMessageType withSourceValue(JsonNullable<? extends MessageSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageMessageType other = (MessageMessageType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessageMessageType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends MessageValue> value = JsonNullable.undefined();

        private JsonNullable<? extends MessageSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unified message type.
         */
        public Builder value(MessageValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified message type.
         */
        public Builder value(JsonNullable<? extends MessageValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(MessageSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(JsonNullable<? extends MessageSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public MessageMessageType build() {

            return new MessageMessageType(
                value, sourceValue);
        }

    }
}
