/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class QuestionValue {
    public static final QuestionValue SHORT_TEXT = new QuestionValue("short_text");
    public static final QuestionValue LONG_TEXT = new QuestionValue("long_text");
    public static final QuestionValue ATTACHMENT = new QuestionValue("attachment");
    public static final QuestionValue MULTI_SELECT = new QuestionValue("multi_select");
    public static final QuestionValue SINGLE_SELECT = new QuestionValue("single_select");
    public static final QuestionValue BOOLEAN = new QuestionValue("boolean");
    public static final QuestionValue NUMBER = new QuestionValue("number");
    public static final QuestionValue DATE = new QuestionValue("date");
    public static final QuestionValue VIDEO = new QuestionValue("video");
    private static final Map<String, QuestionValue> values = QuestionValue.createValuesMap();
    private static final Map<String, QuestionValueEnum> enums = QuestionValue.createEnumsMap();
    private final String value;

    private QuestionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuestionValue of(String value) {
        Class<QuestionValue> clazz = QuestionValue.class;
        synchronized (QuestionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new QuestionValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<QuestionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionValue other = (QuestionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "QuestionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuestionValue[] values() {
        Class<QuestionValue> clazz = QuestionValue.class;
        synchronized (QuestionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new QuestionValue[0]);
        }
    }

    private static final Map<String, QuestionValue> createValuesMap() {
        LinkedHashMap<String, QuestionValue> map = new LinkedHashMap<String, QuestionValue>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        return map;
    }

    private static final Map<String, QuestionValueEnum> createEnumsMap() {
        HashMap<String, QuestionValueEnum> map = new HashMap<String, QuestionValueEnum>();
        map.put("short_text", QuestionValueEnum.SHORT_TEXT);
        map.put("long_text", QuestionValueEnum.LONG_TEXT);
        map.put("attachment", QuestionValueEnum.ATTACHMENT);
        map.put("multi_select", QuestionValueEnum.MULTI_SELECT);
        map.put("single_select", QuestionValueEnum.SINGLE_SELECT);
        map.put("boolean", QuestionValueEnum.BOOLEAN);
        map.put("number", QuestionValueEnum.NUMBER);
        map.put("date", QuestionValueEnum.DATE);
        map.put("video", QuestionValueEnum.VIDEO);
        return map;
    }

    public static enum QuestionValueEnum {
        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video");

        private final String value;

        private QuestionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<QuestionValue> {
        protected _Deserializer() {
            super(QuestionValue.class);
        }

        public QuestionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return QuestionValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<QuestionValue> {
        protected _Serializer() {
            super(QuestionValue.class);
        }

        public void serialize(QuestionValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

