/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.operations.LmsGetCompletionRequest;
import com.stackone.stackone_client_java.models.operations.LmsGetCompletionResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsGetCompletionRequestBuilder {
    private LmsGetCompletionRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallLmsGetCompletion sdk;

    public LmsGetCompletionRequestBuilder(SDKMethodInterfaces.MethodCallLmsGetCompletion sdk) {
        this.sdk = sdk;
    }

    public LmsGetCompletionRequestBuilder request(LmsGetCompletionRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsGetCompletionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsGetCompletionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsGetCompletionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getCompletion(this.request, options);
    }
}

