/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ContentBlocksPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Deprecated;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class MarketingListContentBlocksResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The list of Content Blocks was retrieved.
     */
    private Optional<? extends ContentBlocksPaginated> contentBlocksPaginated;

    private Map<String, List<String>> headers;

    private Callable<Optional<MarketingListContentBlocksResponse>> next = () -> Optional.empty();

    @JsonCreator
    public MarketingListContentBlocksResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends ContentBlocksPaginated> contentBlocksPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.contentBlocksPaginated = contentBlocksPaginated;
        this.headers = headers;
    }
    
    public MarketingListContentBlocksResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of Content Blocks was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ContentBlocksPaginated> contentBlocksPaginated() {
        return (Optional<ContentBlocksPaginated>) contentBlocksPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public Optional<MarketingListContentBlocksResponse> next() throws Exception {
        return this.next.call();
    }
    
    // internal use only
    private MarketingListContentBlocksResponse withNext(Callable<Optional<MarketingListContentBlocksResponse>> next) {
        this.next = next;
        return this;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * HTTP response content type for this operation
     */
    public MarketingListContentBlocksResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public MarketingListContentBlocksResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public MarketingListContentBlocksResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of Content Blocks was retrieved.
     */
    public MarketingListContentBlocksResponse withContentBlocksPaginated(ContentBlocksPaginated contentBlocksPaginated) {
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        this.contentBlocksPaginated = Optional.ofNullable(contentBlocksPaginated);
        return this;
    }

    /**
     * The list of Content Blocks was retrieved.
     */
    public MarketingListContentBlocksResponse withContentBlocksPaginated(Optional<? extends ContentBlocksPaginated> contentBlocksPaginated) {
        Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
        this.contentBlocksPaginated = contentBlocksPaginated;
        return this;
    }

    public MarketingListContentBlocksResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingListContentBlocksResponse other = (MarketingListContentBlocksResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.contentBlocksPaginated, other.contentBlocksPaginated) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            contentBlocksPaginated,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingListContentBlocksResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "contentBlocksPaginated", contentBlocksPaginated,
                "headers", headers);
    }
    
    public final static class Builder {
        private Callable<Optional<MarketingListContentBlocksResponse>> next;
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends ContentBlocksPaginated> contentBlocksPaginated = Optional.empty();
 
        private Map<String, List<String>> headers;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The list of Content Blocks was retrieved.
         */
        public Builder contentBlocksPaginated(ContentBlocksPaginated contentBlocksPaginated) {
            Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
            this.contentBlocksPaginated = Optional.ofNullable(contentBlocksPaginated);
            return this;
        }

        /**
         * The list of Content Blocks was retrieved.
         */
        public Builder contentBlocksPaginated(Optional<? extends ContentBlocksPaginated> contentBlocksPaginated) {
            Utils.checkNotNull(contentBlocksPaginated, "contentBlocksPaginated");
            this.contentBlocksPaginated = contentBlocksPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        /**
         * Internal API. Not for public use. Sets the provider of the next page.
         *
         * @deprecated not part of the public API, may be removed without notice
         */
        @Deprecated
        public Builder next(Callable<Optional<MarketingListContentBlocksResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }
        
        public MarketingListContentBlocksResponse build() {
            return new MarketingListContentBlocksResponse(
                contentType,
                statusCode,
                rawResponse,
                contentBlocksPaginated,
                headers)
                .withNext(next);
        }
    }
}

