/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffPolicyValue {
    public static final TimeOffPolicyValue PAID = new TimeOffPolicyValue("paid");
    public static final TimeOffPolicyValue UNPAID = new TimeOffPolicyValue("unpaid");
    public static final TimeOffPolicyValue HOLIDAY = new TimeOffPolicyValue("holiday");
    public static final TimeOffPolicyValue VACATION = new TimeOffPolicyValue("vacation");
    public static final TimeOffPolicyValue SICK = new TimeOffPolicyValue("sick");
    public static final TimeOffPolicyValue PERSONAL = new TimeOffPolicyValue("personal");
    public static final TimeOffPolicyValue IN_LIEU = new TimeOffPolicyValue("in_lieu");
    public static final TimeOffPolicyValue BEREAVEMENT = new TimeOffPolicyValue("bereavement");
    public static final TimeOffPolicyValue JURY_DUTY = new TimeOffPolicyValue("jury_duty");
    public static final TimeOffPolicyValue UNMAPPED_VALUE = new TimeOffPolicyValue("unmapped_value");
    private static final Map<String, TimeOffPolicyValue> values = TimeOffPolicyValue.createValuesMap();
    private static final Map<String, TimeOffPolicyValueEnum> enums = TimeOffPolicyValue.createEnumsMap();
    private final String value;

    private TimeOffPolicyValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffPolicyValue of(String value) {
        Class<TimeOffPolicyValue> clazz = TimeOffPolicyValue.class;
        synchronized (TimeOffPolicyValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffPolicyValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffPolicyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffPolicyValue other = (TimeOffPolicyValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffPolicyValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffPolicyValue[] values() {
        Class<TimeOffPolicyValue> clazz = TimeOffPolicyValue.class;
        synchronized (TimeOffPolicyValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffPolicyValue[0]);
        }
    }

    private static final Map<String, TimeOffPolicyValue> createValuesMap() {
        LinkedHashMap<String, TimeOffPolicyValue> map = new LinkedHashMap<String, TimeOffPolicyValue>();
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("vacation", VACATION);
        map.put("sick", SICK);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("jury_duty", JURY_DUTY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffPolicyValueEnum> createEnumsMap() {
        HashMap<String, TimeOffPolicyValueEnum> map = new HashMap<String, TimeOffPolicyValueEnum>();
        map.put("paid", TimeOffPolicyValueEnum.PAID);
        map.put("unpaid", TimeOffPolicyValueEnum.UNPAID);
        map.put("holiday", TimeOffPolicyValueEnum.HOLIDAY);
        map.put("vacation", TimeOffPolicyValueEnum.VACATION);
        map.put("sick", TimeOffPolicyValueEnum.SICK);
        map.put("personal", TimeOffPolicyValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffPolicyValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffPolicyValueEnum.BEREAVEMENT);
        map.put("jury_duty", TimeOffPolicyValueEnum.JURY_DUTY);
        map.put("unmapped_value", TimeOffPolicyValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeOffPolicyValueEnum {
        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        VACATION("vacation"),
        SICK("sick"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        JURY_DUTY("jury_duty"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeOffPolicyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffPolicyValue> {
        protected _Deserializer() {
            super(TimeOffPolicyValue.class);
        }

        public TimeOffPolicyValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffPolicyValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffPolicyValue> {
        protected _Serializer() {
            super(TimeOffPolicyValue.class);
        }

        public void serialize(TimeOffPolicyValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

