/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * FileFileFormat
 * 
 * <p>The file format of the file
 */
public class FileFileFormat {

    /**
     * The file format of the file, expressed as a file extension
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends FileValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends FileFileFormatSourceValue> sourceValue;

    @JsonCreator
    public FileFileFormat(
            @JsonProperty("value") JsonNullable<? extends FileValue> value,
            @JsonProperty("source_value") JsonNullable<? extends FileFileFormatSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public FileFileFormat() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FileValue> value() {
        return (JsonNullable<FileValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FileFileFormatSourceValue> sourceValue() {
        return (JsonNullable<FileFileFormatSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The file format of the file, expressed as a file extension
     */
    public FileFileFormat withValue(FileValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    public FileFileFormat withValue(JsonNullable<? extends FileValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public FileFileFormat withSourceValue(FileFileFormatSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public FileFileFormat withSourceValue(JsonNullable<? extends FileFileFormatSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FileFileFormat other = (FileFileFormat) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FileFileFormat.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends FileValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends FileFileFormatSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(FileValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(JsonNullable<? extends FileValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(FileFileFormatSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends FileFileFormatSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public FileFileFormat build() {
            return new FileFileFormat(
                value,
                sourceValue);
        }
    }
}
