/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * FileFormat
 * 
 * <p>The file format of the file
 */
public class FileFormat {

    /**
     * The file format of the file, expressed as a file extension
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HrisDocumentsUploadRequestDtoValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HrisDocumentsUploadRequestDtoSourceValue> sourceValue;

    @JsonCreator
    public FileFormat(
            @JsonProperty("value") JsonNullable<? extends HrisDocumentsUploadRequestDtoValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HrisDocumentsUploadRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public FileFormat() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisDocumentsUploadRequestDtoValue> value() {
        return (JsonNullable<HrisDocumentsUploadRequestDtoValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisDocumentsUploadRequestDtoSourceValue> sourceValue() {
        return (JsonNullable<HrisDocumentsUploadRequestDtoSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The file format of the file, expressed as a file extension
     */
    public FileFormat withValue(HrisDocumentsUploadRequestDtoValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    public FileFormat withValue(JsonNullable<? extends HrisDocumentsUploadRequestDtoValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public FileFormat withSourceValue(HrisDocumentsUploadRequestDtoSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public FileFormat withSourceValue(JsonNullable<? extends HrisDocumentsUploadRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FileFormat other = (FileFormat) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FileFormat.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends HrisDocumentsUploadRequestDtoValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisDocumentsUploadRequestDtoSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(HrisDocumentsUploadRequestDtoValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(JsonNullable<? extends HrisDocumentsUploadRequestDtoValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(HrisDocumentsUploadRequestDtoSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends HrisDocumentsUploadRequestDtoSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public FileFormat build() {
            return new FileFormat(
                value,
                sourceValue);
        }
    }
}
