/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public final class Multipart {
    private static final String DASHES = "--";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String boundary;

    private Multipart(HttpRequest.BodyPublisher bodyPublisher, String boundary) {
        this.bodyPublisher = bodyPublisher;
        this.boundary = boundary;
    }

    public HttpRequest.BodyPublisher bodyPublisher() {
        return this.bodyPublisher;
    }

    public String contentType() {
        return "multipart/form-data; charset=" + StandardCharsets.ISO_8859_1.name() + "; boundary=" + this.boundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class PartsIterator
    implements Iterator<byte[]> {
        private final Iterator<Part> iter;
        private final String boundary;
        private InputStream currentFileInput;
        private boolean done;
        private byte[] next;

        PartsIterator(List<Part> parts, String boundary) {
            this.iter = parts.iterator();
            this.boundary = boundary;
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.computeNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.next == null) {
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] res = this.next;
            this.next = null;
            return res;
        }

        private byte[] computeNext() throws IOException {
            if (this.currentFileInput == null) {
                if (!this.iter.hasNext()) {
                    return null;
                }
                Part nextPart = this.iter.next();
                if (PartType.STRING.equals((Object)nextPart.type)) {
                    String part = Multipart.DASHES + this.boundary + "\r\nContent-Disposition: form-data; name=\"" + nextPart.name + "\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n" + nextPart.value + "\r\n";
                    return part.getBytes(StandardCharsets.UTF_8);
                }
                if (PartType.FINAL_BOUNDARY.equals((Object)nextPart.type)) {
                    return nextPart.value.getBytes(StandardCharsets.UTF_8);
                }
                String filename = nextPart.filename;
                String contentType = nextPart.contentType;
                if (contentType == null) {
                    contentType = Multipart.APPLICATION_OCTET_STREAM;
                }
                this.currentFileInput = nextPart.stream.get();
                String partHeader = Multipart.DASHES + this.boundary + "\r\nContent-Disposition: form-data; name=\"" + nextPart.name + "\"; filename=\"" + filename + "\"\r\nContent-Type: " + contentType + "\r\n\r\n";
                return partHeader.getBytes(StandardCharsets.UTF_8);
            }
            byte[] buf = new byte[8192];
            int r = this.currentFileInput.read(buf);
            if (r > 0) {
                byte[] actualBytes = new byte[r];
                System.arraycopy(buf, 0, actualBytes, 0, r);
                return actualBytes;
            }
            this.currentFileInput.close();
            this.currentFileInput = null;
            return "\r\n".getBytes(StandardCharsets.UTF_8);
        }
    }

    static final class Part {
        PartType type;
        String name;
        String value;
        Supplier<InputStream> stream;
        String filename;
        String contentType;

        Part() {
        }
    }

    public static enum PartType {
        STRING,
        STREAM,
        FINAL_BOUNDARY;

    }

    public static final class Builder {
        private final List<Part> parts = new ArrayList<Part>();
        private final String boundary = UUID.randomUUID().toString();

        public Builder addPart(String name, String value) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Part p = new Part();
            p.type = PartType.STRING;
            p.name = name;
            p.value = value;
            this.parts.add(p);
            return this;
        }

        public Builder addPart(String name, String value, String contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(contentType, "contentType");
            Part p = new Part();
            p.type = PartType.STRING;
            p.name = name;
            p.value = value;
            p.contentType = contentType;
            this.parts.add(p);
            return this;
        }

        public Builder addPart(String name, Supplier<InputStream> stream, String filename, Optional<String> contentType) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(stream, "stream");
            Utils.checkNotNull(filename, "filename");
            Utils.checkNotNull(contentType, "contentType");
            Part p = new Part();
            p.type = PartType.STREAM;
            p.name = name;
            p.stream = stream;
            p.filename = filename;
            p.contentType = contentType.orElse(null);
            this.parts.add(p);
            return this;
        }

        private void addFinalBoundaryPart() {
            Part p = new Part();
            p.type = PartType.FINAL_BOUNDARY;
            p.value = Multipart.DASHES + this.boundary + Multipart.DASHES;
            this.parts.add(p);
        }

        public Multipart build() {
            if (this.parts.size() == 0) {
                throw new IllegalStateException("Must have at least one part to build multipart message.");
            }
            this.addFinalBoundaryPart();
            HttpRequest.BodyPublisher bp = HttpRequest.BodyPublishers.ofByteArrays(() -> new PartsIterator(this.parts, this.boundary));
            return new Multipart(bp, this.boundary);
        }
    }
}

