/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class Content {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The external ID associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    private JsonNullable<String> externalReference;

    /**
     * The parent ID/IDs associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("course_ids")
    private JsonNullable<? extends List<String>> courseIds;

    /**
     * Provider's unique identifier of the parent course ID associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_course_ids")
    private JsonNullable<? extends List<String>> remoteCourseIds;

    /**
     * The title of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The description of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The languages associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("languages")
    private JsonNullable<? extends List<LanguageEnum>> languages;

    /**
     * The external URL of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_url")
    private JsonNullable<String> contentUrl;

    /**
     * The mobile friendly URL of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mobile_launch_content_url")
    private JsonNullable<String> mobileLaunchContentUrl;

    /**
     * The type of content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_type")
    private JsonNullable<? extends ContentType> contentType;

    /**
     * The URL of the thumbnail image associated with the content.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cover_url")
    private JsonNullable<String> coverUrl;

    /**
     * Whether the content is active and available for users.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends Active> active;

    /**
     * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("duration")
    private JsonNullable<String> duration;

    /**
     * The categories associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("categories")
    private JsonNullable<? extends List<Category>> categories;

    /**
     * The skills associated with this course
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("skills")
    private JsonNullable<? extends List<Skills>> skills;

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("order")
    private JsonNullable<Double> order;

    /**
     * The name of the content provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider")
    private JsonNullable<String> provider;

    /**
     * A short description or summary for the content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("short_description")
    @Deprecated
    private JsonNullable<String> shortDescription;

    /**
     * Localised content information
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("localizations")
    private JsonNullable<? extends List<LocalizationModel>> localizations;

    /**
     * A list of tags associated with the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tags")
    private JsonNullable<? extends List<String>> tags;

    /**
     * The date on which the content was last updated.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The date on which the content was created.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    @JsonCreator
    public Content(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("course_ids") JsonNullable<? extends List<String>> courseIds,
            @JsonProperty("remote_course_ids") JsonNullable<? extends List<String>> remoteCourseIds,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("languages") JsonNullable<? extends List<LanguageEnum>> languages,
            @JsonProperty("content_url") JsonNullable<String> contentUrl,
            @JsonProperty("mobile_launch_content_url") JsonNullable<String> mobileLaunchContentUrl,
            @JsonProperty("content_type") JsonNullable<? extends ContentType> contentType,
            @JsonProperty("cover_url") JsonNullable<String> coverUrl,
            @JsonProperty("active") JsonNullable<? extends Active> active,
            @JsonProperty("duration") JsonNullable<String> duration,
            @JsonProperty("categories") JsonNullable<? extends List<Category>> categories,
            @JsonProperty("skills") JsonNullable<? extends List<Skills>> skills,
            @JsonProperty("order") JsonNullable<Double> order,
            @JsonProperty("provider") JsonNullable<String> provider,
            @JsonProperty("short_description") JsonNullable<String> shortDescription,
            @JsonProperty("localizations") JsonNullable<? extends List<LocalizationModel>> localizations,
            @JsonProperty("tags") JsonNullable<? extends List<String>> tags,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(courseIds, "courseIds");
        Utils.checkNotNull(remoteCourseIds, "remoteCourseIds");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(languages, "languages");
        Utils.checkNotNull(contentUrl, "contentUrl");
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(coverUrl, "coverUrl");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(duration, "duration");
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(skills, "skills");
        Utils.checkNotNull(order, "order");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(shortDescription, "shortDescription");
        Utils.checkNotNull(localizations, "localizations");
        Utils.checkNotNull(tags, "tags");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.externalReference = externalReference;
        this.courseIds = courseIds;
        this.remoteCourseIds = remoteCourseIds;
        this.title = title;
        this.description = description;
        this.languages = languages;
        this.contentUrl = contentUrl;
        this.mobileLaunchContentUrl = mobileLaunchContentUrl;
        this.contentType = contentType;
        this.coverUrl = coverUrl;
        this.active = active;
        this.duration = duration;
        this.categories = categories;
        this.skills = skills;
        this.order = order;
        this.provider = provider;
        this.shortDescription = shortDescription;
        this.localizations = localizations;
        this.tags = tags;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }
    
    public Content() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The external ID associated with this content
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The parent ID/IDs associated with this content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> courseIds() {
        return (JsonNullable<List<String>>) courseIds;
    }

    /**
     * Provider's unique identifier of the parent course ID associated with this content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteCourseIds() {
        return (JsonNullable<List<String>>) remoteCourseIds;
    }

    /**
     * The title of the content
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The description of the content
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The languages associated with this content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<LanguageEnum>> languages() {
        return (JsonNullable<List<LanguageEnum>>) languages;
    }

    /**
     * The external URL of the content
     */
    @JsonIgnore
    public JsonNullable<String> contentUrl() {
        return contentUrl;
    }

    /**
     * The mobile friendly URL of the content
     */
    @JsonIgnore
    public JsonNullable<String> mobileLaunchContentUrl() {
        return mobileLaunchContentUrl;
    }

    /**
     * The type of content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContentType> contentType() {
        return (JsonNullable<ContentType>) contentType;
    }

    /**
     * The URL of the thumbnail image associated with the content.
     */
    @JsonIgnore
    public JsonNullable<String> coverUrl() {
        return coverUrl;
    }

    /**
     * Whether the content is active and available for users.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Active> active() {
        return (JsonNullable<Active>) active;
    }

    /**
     * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
     */
    @JsonIgnore
    public JsonNullable<String> duration() {
        return duration;
    }

    /**
     * The categories associated with this content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Category>> categories() {
        return (JsonNullable<List<Category>>) categories;
    }

    /**
     * The skills associated with this course
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Skills>> skills() {
        return (JsonNullable<List<Skills>>) skills;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    @JsonIgnore
    public JsonNullable<Double> order() {
        return order;
    }

    /**
     * The name of the content provider
     */
    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    /**
     * A short description or summary for the content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> shortDescription() {
        return shortDescription;
    }

    /**
     * Localised content information
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<LocalizationModel>> localizations() {
        return (JsonNullable<List<LocalizationModel>>) localizations;
    }

    /**
     * A list of tags associated with the content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> tags() {
        return (JsonNullable<List<String>>) tags;
    }

    /**
     * The date on which the content was last updated.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The date on which the content was created.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public Content withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Content withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Content withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Content withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Content withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Content withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The external ID associated with this content
     */
    public Content withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external ID associated with this content
     */
    public Content withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The parent ID/IDs associated with this content
     */
    public Content withCourseIds(List<String> courseIds) {
        Utils.checkNotNull(courseIds, "courseIds");
        this.courseIds = JsonNullable.of(courseIds);
        return this;
    }

    /**
     * The parent ID/IDs associated with this content
     */
    public Content withCourseIds(JsonNullable<? extends List<String>> courseIds) {
        Utils.checkNotNull(courseIds, "courseIds");
        this.courseIds = courseIds;
        return this;
    }

    /**
     * Provider's unique identifier of the parent course ID associated with this content
     */
    public Content withRemoteCourseIds(List<String> remoteCourseIds) {
        Utils.checkNotNull(remoteCourseIds, "remoteCourseIds");
        this.remoteCourseIds = JsonNullable.of(remoteCourseIds);
        return this;
    }

    /**
     * Provider's unique identifier of the parent course ID associated with this content
     */
    public Content withRemoteCourseIds(JsonNullable<? extends List<String>> remoteCourseIds) {
        Utils.checkNotNull(remoteCourseIds, "remoteCourseIds");
        this.remoteCourseIds = remoteCourseIds;
        return this;
    }

    /**
     * The title of the content
     */
    public Content withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * The title of the content
     */
    public Content withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The description of the content
     */
    public Content withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the content
     */
    public Content withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The languages associated with this content
     */
    public Content withLanguages(List<LanguageEnum> languages) {
        Utils.checkNotNull(languages, "languages");
        this.languages = JsonNullable.of(languages);
        return this;
    }

    /**
     * The languages associated with this content
     */
    public Content withLanguages(JsonNullable<? extends List<LanguageEnum>> languages) {
        Utils.checkNotNull(languages, "languages");
        this.languages = languages;
        return this;
    }

    /**
     * The external URL of the content
     */
    public Content withContentUrl(String contentUrl) {
        Utils.checkNotNull(contentUrl, "contentUrl");
        this.contentUrl = JsonNullable.of(contentUrl);
        return this;
    }

    /**
     * The external URL of the content
     */
    public Content withContentUrl(JsonNullable<String> contentUrl) {
        Utils.checkNotNull(contentUrl, "contentUrl");
        this.contentUrl = contentUrl;
        return this;
    }

    /**
     * The mobile friendly URL of the content
     */
    public Content withMobileLaunchContentUrl(String mobileLaunchContentUrl) {
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        this.mobileLaunchContentUrl = JsonNullable.of(mobileLaunchContentUrl);
        return this;
    }

    /**
     * The mobile friendly URL of the content
     */
    public Content withMobileLaunchContentUrl(JsonNullable<String> mobileLaunchContentUrl) {
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        this.mobileLaunchContentUrl = mobileLaunchContentUrl;
        return this;
    }

    /**
     * The type of content
     */
    public Content withContentType(ContentType contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = JsonNullable.of(contentType);
        return this;
    }

    /**
     * The type of content
     */
    public Content withContentType(JsonNullable<? extends ContentType> contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * The URL of the thumbnail image associated with the content.
     */
    public Content withCoverUrl(String coverUrl) {
        Utils.checkNotNull(coverUrl, "coverUrl");
        this.coverUrl = JsonNullable.of(coverUrl);
        return this;
    }

    /**
     * The URL of the thumbnail image associated with the content.
     */
    public Content withCoverUrl(JsonNullable<String> coverUrl) {
        Utils.checkNotNull(coverUrl, "coverUrl");
        this.coverUrl = coverUrl;
        return this;
    }

    /**
     * Whether the content is active and available for users.
     */
    public Content withActive(Active active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the content is active and available for users.
     */
    public Content withActive(JsonNullable<? extends Active> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    /**
     * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
     */
    public Content withDuration(String duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = JsonNullable.of(duration);
        return this;
    }

    /**
     * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
     */
    public Content withDuration(JsonNullable<String> duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = duration;
        return this;
    }

    /**
     * The categories associated with this content
     */
    public Content withCategories(List<Category> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    /**
     * The categories associated with this content
     */
    public Content withCategories(JsonNullable<? extends List<Category>> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    /**
     * The skills associated with this course
     */
    public Content withSkills(List<Skills> skills) {
        Utils.checkNotNull(skills, "skills");
        this.skills = JsonNullable.of(skills);
        return this;
    }

    /**
     * The skills associated with this course
     */
    public Content withSkills(JsonNullable<? extends List<Skills>> skills) {
        Utils.checkNotNull(skills, "skills");
        this.skills = skills;
        return this;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    public Content withOrder(double order) {
        Utils.checkNotNull(order, "order");
        this.order = JsonNullable.of(order);
        return this;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    public Content withOrder(JsonNullable<Double> order) {
        Utils.checkNotNull(order, "order");
        this.order = order;
        return this;
    }

    /**
     * The name of the content provider
     */
    public Content withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    /**
     * The name of the content provider
     */
    public Content withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * A short description or summary for the content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Content withShortDescription(String shortDescription) {
        Utils.checkNotNull(shortDescription, "shortDescription");
        this.shortDescription = JsonNullable.of(shortDescription);
        return this;
    }

    /**
     * A short description or summary for the content
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Content withShortDescription(JsonNullable<String> shortDescription) {
        Utils.checkNotNull(shortDescription, "shortDescription");
        this.shortDescription = shortDescription;
        return this;
    }

    /**
     * Localised content information
     */
    public Content withLocalizations(List<LocalizationModel> localizations) {
        Utils.checkNotNull(localizations, "localizations");
        this.localizations = JsonNullable.of(localizations);
        return this;
    }

    /**
     * Localised content information
     */
    public Content withLocalizations(JsonNullable<? extends List<LocalizationModel>> localizations) {
        Utils.checkNotNull(localizations, "localizations");
        this.localizations = localizations;
        return this;
    }

    /**
     * A list of tags associated with the content
     */
    public Content withTags(List<String> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = JsonNullable.of(tags);
        return this;
    }

    /**
     * A list of tags associated with the content
     */
    public Content withTags(JsonNullable<? extends List<String>> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = tags;
        return this;
    }

    /**
     * The date on which the content was last updated.
     */
    public Content withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date on which the content was last updated.
     */
    public Content withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The date on which the content was created.
     */
    public Content withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date on which the content was created.
     */
    public Content withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Content other = (Content) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference) &&
            Utils.enhancedDeepEquals(this.courseIds, other.courseIds) &&
            Utils.enhancedDeepEquals(this.remoteCourseIds, other.remoteCourseIds) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.languages, other.languages) &&
            Utils.enhancedDeepEquals(this.contentUrl, other.contentUrl) &&
            Utils.enhancedDeepEquals(this.mobileLaunchContentUrl, other.mobileLaunchContentUrl) &&
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.coverUrl, other.coverUrl) &&
            Utils.enhancedDeepEquals(this.active, other.active) &&
            Utils.enhancedDeepEquals(this.duration, other.duration) &&
            Utils.enhancedDeepEquals(this.categories, other.categories) &&
            Utils.enhancedDeepEquals(this.skills, other.skills) &&
            Utils.enhancedDeepEquals(this.order, other.order) &&
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.shortDescription, other.shortDescription) &&
            Utils.enhancedDeepEquals(this.localizations, other.localizations) &&
            Utils.enhancedDeepEquals(this.tags, other.tags) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            unifiedCustomFields,
            externalReference,
            courseIds,
            remoteCourseIds,
            title,
            description,
            languages,
            contentUrl,
            mobileLaunchContentUrl,
            contentType,
            coverUrl,
            active,
            duration,
            categories,
            skills,
            order,
            provider,
            shortDescription,
            localizations,
            tags,
            updatedAt,
            createdAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Content.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "externalReference", externalReference,
                "courseIds", courseIds,
                "remoteCourseIds", remoteCourseIds,
                "title", title,
                "description", description,
                "languages", languages,
                "contentUrl", contentUrl,
                "mobileLaunchContentUrl", mobileLaunchContentUrl,
                "contentType", contentType,
                "coverUrl", coverUrl,
                "active", active,
                "duration", duration,
                "categories", categories,
                "skills", skills,
                "order", order,
                "provider", provider,
                "shortDescription", shortDescription,
                "localizations", localizations,
                "tags", tags,
                "updatedAt", updatedAt,
                "createdAt", createdAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> externalReference = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> courseIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteCourseIds = JsonNullable.undefined();
 
        private JsonNullable<String> title = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
 
        private JsonNullable<? extends List<LanguageEnum>> languages = JsonNullable.undefined();
 
        private JsonNullable<String> contentUrl = JsonNullable.undefined();
 
        private JsonNullable<String> mobileLaunchContentUrl = JsonNullable.undefined();
 
        private JsonNullable<? extends ContentType> contentType = JsonNullable.undefined();
 
        private JsonNullable<String> coverUrl = JsonNullable.undefined();
 
        private JsonNullable<? extends Active> active = JsonNullable.undefined();
 
        private JsonNullable<String> duration = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Category>> categories = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Skills>> skills = JsonNullable.undefined();
 
        private JsonNullable<Double> order = JsonNullable.undefined();
 
        private JsonNullable<String> provider = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> shortDescription = JsonNullable.undefined();
 
        private JsonNullable<? extends List<LocalizationModel>> localizations = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> tags = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The external ID associated with this content
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external ID associated with this content
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }

        /**
         * The parent ID/IDs associated with this content
         */
        public Builder courseIds(List<String> courseIds) {
            Utils.checkNotNull(courseIds, "courseIds");
            this.courseIds = JsonNullable.of(courseIds);
            return this;
        }

        /**
         * The parent ID/IDs associated with this content
         */
        public Builder courseIds(JsonNullable<? extends List<String>> courseIds) {
            Utils.checkNotNull(courseIds, "courseIds");
            this.courseIds = courseIds;
            return this;
        }

        /**
         * Provider's unique identifier of the parent course ID associated with this content
         */
        public Builder remoteCourseIds(List<String> remoteCourseIds) {
            Utils.checkNotNull(remoteCourseIds, "remoteCourseIds");
            this.remoteCourseIds = JsonNullable.of(remoteCourseIds);
            return this;
        }

        /**
         * Provider's unique identifier of the parent course ID associated with this content
         */
        public Builder remoteCourseIds(JsonNullable<? extends List<String>> remoteCourseIds) {
            Utils.checkNotNull(remoteCourseIds, "remoteCourseIds");
            this.remoteCourseIds = remoteCourseIds;
            return this;
        }

        /**
         * The title of the content
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * The title of the content
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        /**
         * The description of the content
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the content
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * The languages associated with this content
         */
        public Builder languages(List<LanguageEnum> languages) {
            Utils.checkNotNull(languages, "languages");
            this.languages = JsonNullable.of(languages);
            return this;
        }

        /**
         * The languages associated with this content
         */
        public Builder languages(JsonNullable<? extends List<LanguageEnum>> languages) {
            Utils.checkNotNull(languages, "languages");
            this.languages = languages;
            return this;
        }

        /**
         * The external URL of the content
         */
        public Builder contentUrl(String contentUrl) {
            Utils.checkNotNull(contentUrl, "contentUrl");
            this.contentUrl = JsonNullable.of(contentUrl);
            return this;
        }

        /**
         * The external URL of the content
         */
        public Builder contentUrl(JsonNullable<String> contentUrl) {
            Utils.checkNotNull(contentUrl, "contentUrl");
            this.contentUrl = contentUrl;
            return this;
        }

        /**
         * The mobile friendly URL of the content
         */
        public Builder mobileLaunchContentUrl(String mobileLaunchContentUrl) {
            Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
            this.mobileLaunchContentUrl = JsonNullable.of(mobileLaunchContentUrl);
            return this;
        }

        /**
         * The mobile friendly URL of the content
         */
        public Builder mobileLaunchContentUrl(JsonNullable<String> mobileLaunchContentUrl) {
            Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
            this.mobileLaunchContentUrl = mobileLaunchContentUrl;
            return this;
        }

        /**
         * The type of content
         */
        public Builder contentType(ContentType contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = JsonNullable.of(contentType);
            return this;
        }

        /**
         * The type of content
         */
        public Builder contentType(JsonNullable<? extends ContentType> contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * The URL of the thumbnail image associated with the content.
         */
        public Builder coverUrl(String coverUrl) {
            Utils.checkNotNull(coverUrl, "coverUrl");
            this.coverUrl = JsonNullable.of(coverUrl);
            return this;
        }

        /**
         * The URL of the thumbnail image associated with the content.
         */
        public Builder coverUrl(JsonNullable<String> coverUrl) {
            Utils.checkNotNull(coverUrl, "coverUrl");
            this.coverUrl = coverUrl;
            return this;
        }

        /**
         * Whether the content is active and available for users.
         */
        public Builder active(Active active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the content is active and available for users.
         */
        public Builder active(JsonNullable<? extends Active> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        /**
         * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
         */
        public Builder duration(String duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = JsonNullable.of(duration);
            return this;
        }

        /**
         * The duration of the content following the ISO8601 standard. If duration_unit is applicable we will derive this from the smallest unit given in the duration string or the minimum unit accepted by the provider.
         */
        public Builder duration(JsonNullable<String> duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = duration;
            return this;
        }

        /**
         * The categories associated with this content
         */
        public Builder categories(List<Category> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        /**
         * The categories associated with this content
         */
        public Builder categories(JsonNullable<? extends List<Category>> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }

        /**
         * The skills associated with this course
         */
        public Builder skills(List<Skills> skills) {
            Utils.checkNotNull(skills, "skills");
            this.skills = JsonNullable.of(skills);
            return this;
        }

        /**
         * The skills associated with this course
         */
        public Builder skills(JsonNullable<? extends List<Skills>> skills) {
            Utils.checkNotNull(skills, "skills");
            this.skills = skills;
            return this;
        }

        /**
         * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
         */
        public Builder order(double order) {
            Utils.checkNotNull(order, "order");
            this.order = JsonNullable.of(order);
            return this;
        }

        /**
         * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
         */
        public Builder order(JsonNullable<Double> order) {
            Utils.checkNotNull(order, "order");
            this.order = order;
            return this;
        }

        /**
         * The name of the content provider
         */
        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        /**
         * The name of the content provider
         */
        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        /**
         * A short description or summary for the content
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder shortDescription(String shortDescription) {
            Utils.checkNotNull(shortDescription, "shortDescription");
            this.shortDescription = JsonNullable.of(shortDescription);
            return this;
        }

        /**
         * A short description or summary for the content
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder shortDescription(JsonNullable<String> shortDescription) {
            Utils.checkNotNull(shortDescription, "shortDescription");
            this.shortDescription = shortDescription;
            return this;
        }

        /**
         * Localised content information
         */
        public Builder localizations(List<LocalizationModel> localizations) {
            Utils.checkNotNull(localizations, "localizations");
            this.localizations = JsonNullable.of(localizations);
            return this;
        }

        /**
         * Localised content information
         */
        public Builder localizations(JsonNullable<? extends List<LocalizationModel>> localizations) {
            Utils.checkNotNull(localizations, "localizations");
            this.localizations = localizations;
            return this;
        }

        /**
         * A list of tags associated with the content
         */
        public Builder tags(List<String> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = JsonNullable.of(tags);
            return this;
        }

        /**
         * A list of tags associated with the content
         */
        public Builder tags(JsonNullable<? extends List<String>> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        /**
         * The date on which the content was last updated.
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date on which the content was last updated.
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * The date on which the content was created.
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date on which the content was created.
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }
        
        public Content build() {
            return new Content(
                id,
                remoteId,
                unifiedCustomFields,
                externalReference,
                courseIds,
                remoteCourseIds,
                title,
                description,
                languages,
                contentUrl,
                mobileLaunchContentUrl,
                contentType,
                coverUrl,
                active,
                duration,
                categories,
                skills,
                order,
                provider,
                shortDescription,
                localizations,
                tags,
                updatedAt,
                createdAt);
        }
    }
}
