/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = EntitySkillsMaximumProficiencyValue._Deserializer.class)
@JsonSerialize(using = EntitySkillsMaximumProficiencyValue._Serializer.class)
public class EntitySkillsMaximumProficiencyValue {

    public static final EntitySkillsMaximumProficiencyValue ONE = new EntitySkillsMaximumProficiencyValue("1");
    public static final EntitySkillsMaximumProficiencyValue TWO = new EntitySkillsMaximumProficiencyValue("2");
    public static final EntitySkillsMaximumProficiencyValue THREE = new EntitySkillsMaximumProficiencyValue("3");
    public static final EntitySkillsMaximumProficiencyValue FOUR = new EntitySkillsMaximumProficiencyValue("4");
    public static final EntitySkillsMaximumProficiencyValue FIVE = new EntitySkillsMaximumProficiencyValue("5");
    public static final EntitySkillsMaximumProficiencyValue UNMAPPED_VALUE = new EntitySkillsMaximumProficiencyValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, EntitySkillsMaximumProficiencyValue> values = createValuesMap();
    private static final Map<String, EntitySkillsMaximumProficiencyValueEnum> enums = createEnumsMap();

    private final String value;

    private EntitySkillsMaximumProficiencyValue(String value) {
        this.value = value;
    }

    /**
     * Returns a EntitySkillsMaximumProficiencyValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as EntitySkillsMaximumProficiencyValue
     */ 
    public static EntitySkillsMaximumProficiencyValue of(String value) {
        synchronized (EntitySkillsMaximumProficiencyValue.class) {
            return values.computeIfAbsent(value, v -> new EntitySkillsMaximumProficiencyValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<EntitySkillsMaximumProficiencyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EntitySkillsMaximumProficiencyValue other = (EntitySkillsMaximumProficiencyValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "EntitySkillsMaximumProficiencyValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static EntitySkillsMaximumProficiencyValue[] values() {
        synchronized (EntitySkillsMaximumProficiencyValue.class) {
            return values.values().toArray(new EntitySkillsMaximumProficiencyValue[] {});
        }
    }

    private static final Map<String, EntitySkillsMaximumProficiencyValue> createValuesMap() {
        Map<String, EntitySkillsMaximumProficiencyValue> map = new LinkedHashMap<>();
        map.put("1", ONE);
        map.put("2", TWO);
        map.put("3", THREE);
        map.put("4", FOUR);
        map.put("5", FIVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EntitySkillsMaximumProficiencyValueEnum> createEnumsMap() {
        Map<String, EntitySkillsMaximumProficiencyValueEnum> map = new HashMap<>();
        map.put("1", EntitySkillsMaximumProficiencyValueEnum.ONE);
        map.put("2", EntitySkillsMaximumProficiencyValueEnum.TWO);
        map.put("3", EntitySkillsMaximumProficiencyValueEnum.THREE);
        map.put("4", EntitySkillsMaximumProficiencyValueEnum.FOUR);
        map.put("5", EntitySkillsMaximumProficiencyValueEnum.FIVE);
        map.put("unmapped_value", EntitySkillsMaximumProficiencyValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<EntitySkillsMaximumProficiencyValue> {

        protected _Serializer() {
            super(EntitySkillsMaximumProficiencyValue.class);
        }

        @Override
        public void serialize(EntitySkillsMaximumProficiencyValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<EntitySkillsMaximumProficiencyValue> {

        protected _Deserializer() {
            super(EntitySkillsMaximumProficiencyValue.class);
        }

        @Override
        public EntitySkillsMaximumProficiencyValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return EntitySkillsMaximumProficiencyValue.of(v);
        }
    }
    
    public enum EntitySkillsMaximumProficiencyValueEnum {

        ONE("1"),
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private EntitySkillsMaximumProficiencyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

