/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class Note {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<? extends List<NoteContentApiModel>> content;

    /**
     * Unique identifier of the author
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("author_id")
    private JsonNullable<String> authorId;

    /**
     * Provider's unique identifier of the author
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_author_id")
    private JsonNullable<String> remoteAuthorId;

    /**
     * Visibility of the note
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("visibility")
    private JsonNullable<? extends Visibility> visibility;

    /**
     * Date of creation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Date of last update
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * Date of Deletion
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("deleted_at")
    private JsonNullable<OffsetDateTime> deletedAt;

    @JsonCreator
    public Note(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("content") JsonNullable<? extends List<NoteContentApiModel>> content,
            @JsonProperty("author_id") JsonNullable<String> authorId,
            @JsonProperty("remote_author_id") JsonNullable<String> remoteAuthorId,
            @JsonProperty("visibility") JsonNullable<? extends Visibility> visibility,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("deleted_at") JsonNullable<OffsetDateTime> deletedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(authorId, "authorId");
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        Utils.checkNotNull(visibility, "visibility");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(deletedAt, "deletedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.content = content;
        this.authorId = authorId;
        this.remoteAuthorId = remoteAuthorId;
        this.visibility = visibility;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
    }
    
    public Note() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<NoteContentApiModel>> content() {
        return (JsonNullable<List<NoteContentApiModel>>) content;
    }

    /**
     * Unique identifier of the author
     */
    @JsonIgnore
    public JsonNullable<String> authorId() {
        return authorId;
    }

    /**
     * Provider's unique identifier of the author
     */
    @JsonIgnore
    public JsonNullable<String> remoteAuthorId() {
        return remoteAuthorId;
    }

    /**
     * Visibility of the note
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Visibility> visibility() {
        return (JsonNullable<Visibility>) visibility;
    }

    /**
     * Date of creation
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Date of last update
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * Date of Deletion
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> deletedAt() {
        return deletedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public Note withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Note withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Note withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Note withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Note withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Note withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    public Note withContent(List<NoteContentApiModel> content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    public Note withContent(JsonNullable<? extends List<NoteContentApiModel>> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * Unique identifier of the author
     */
    public Note withAuthorId(String authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = JsonNullable.of(authorId);
        return this;
    }

    /**
     * Unique identifier of the author
     */
    public Note withAuthorId(JsonNullable<String> authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = authorId;
        return this;
    }

    /**
     * Provider's unique identifier of the author
     */
    public Note withRemoteAuthorId(String remoteAuthorId) {
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        this.remoteAuthorId = JsonNullable.of(remoteAuthorId);
        return this;
    }

    /**
     * Provider's unique identifier of the author
     */
    public Note withRemoteAuthorId(JsonNullable<String> remoteAuthorId) {
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        this.remoteAuthorId = remoteAuthorId;
        return this;
    }

    /**
     * Visibility of the note
     */
    public Note withVisibility(Visibility visibility) {
        Utils.checkNotNull(visibility, "visibility");
        this.visibility = JsonNullable.of(visibility);
        return this;
    }

    /**
     * Visibility of the note
     */
    public Note withVisibility(JsonNullable<? extends Visibility> visibility) {
        Utils.checkNotNull(visibility, "visibility");
        this.visibility = visibility;
        return this;
    }

    /**
     * Date of creation
     */
    public Note withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Date of creation
     */
    public Note withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Date of last update
     */
    public Note withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Date of last update
     */
    public Note withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Date of Deletion
     */
    public Note withDeletedAt(OffsetDateTime deletedAt) {
        Utils.checkNotNull(deletedAt, "deletedAt");
        this.deletedAt = JsonNullable.of(deletedAt);
        return this;
    }

    /**
     * Date of Deletion
     */
    public Note withDeletedAt(JsonNullable<OffsetDateTime> deletedAt) {
        Utils.checkNotNull(deletedAt, "deletedAt");
        this.deletedAt = deletedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Note other = (Note) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.authorId, other.authorId) &&
            Utils.enhancedDeepEquals(this.remoteAuthorId, other.remoteAuthorId) &&
            Utils.enhancedDeepEquals(this.visibility, other.visibility) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.deletedAt, other.deletedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            unifiedCustomFields,
            content,
            authorId,
            remoteAuthorId,
            visibility,
            createdAt,
            updatedAt,
            deletedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Note.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "content", content,
                "authorId", authorId,
                "remoteAuthorId", remoteAuthorId,
                "visibility", visibility,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "deletedAt", deletedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<? extends List<NoteContentApiModel>> content = JsonNullable.undefined();
 
        private JsonNullable<String> authorId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteAuthorId = JsonNullable.undefined();
 
        private JsonNullable<? extends Visibility> visibility = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> deletedAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        public Builder content(List<NoteContentApiModel> content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        public Builder content(JsonNullable<? extends List<NoteContentApiModel>> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        /**
         * Unique identifier of the author
         */
        public Builder authorId(String authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = JsonNullable.of(authorId);
            return this;
        }

        /**
         * Unique identifier of the author
         */
        public Builder authorId(JsonNullable<String> authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = authorId;
            return this;
        }

        /**
         * Provider's unique identifier of the author
         */
        public Builder remoteAuthorId(String remoteAuthorId) {
            Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
            this.remoteAuthorId = JsonNullable.of(remoteAuthorId);
            return this;
        }

        /**
         * Provider's unique identifier of the author
         */
        public Builder remoteAuthorId(JsonNullable<String> remoteAuthorId) {
            Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
            this.remoteAuthorId = remoteAuthorId;
            return this;
        }

        /**
         * Visibility of the note
         */
        public Builder visibility(Visibility visibility) {
            Utils.checkNotNull(visibility, "visibility");
            this.visibility = JsonNullable.of(visibility);
            return this;
        }

        /**
         * Visibility of the note
         */
        public Builder visibility(JsonNullable<? extends Visibility> visibility) {
            Utils.checkNotNull(visibility, "visibility");
            this.visibility = visibility;
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * Date of Deletion
         */
        public Builder deletedAt(OffsetDateTime deletedAt) {
            Utils.checkNotNull(deletedAt, "deletedAt");
            this.deletedAt = JsonNullable.of(deletedAt);
            return this;
        }

        /**
         * Date of Deletion
         */
        public Builder deletedAt(JsonNullable<OffsetDateTime> deletedAt) {
            Utils.checkNotNull(deletedAt, "deletedAt");
            this.deletedAt = deletedAt;
            return this;
        }
        
        public Note build() {
            return new Note(
                id,
                remoteId,
                unifiedCustomFields,
                content,
                authorId,
                remoteAuthorId,
                visibility,
                createdAt,
                updatedAt,
                deletedAt);
        }
    }
}
