/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateNotesRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;

public class AtsCreateApplicationNoteRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateNotesRequestDto atsCreateNotesRequestDto;

    @JsonCreator
    public AtsCreateApplicationNoteRequest(
            String xAccountId,
            String id,
            AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public AtsCreateNotesRequestDto atsCreateNotesRequestDto() {
        return atsCreateNotesRequestDto;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public AtsCreateApplicationNoteRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateApplicationNoteRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsCreateApplicationNoteRequest withAtsCreateNotesRequestDto(AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
        this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateApplicationNoteRequest other = (AtsCreateApplicationNoteRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.atsCreateNotesRequestDto, other.atsCreateNotesRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId,
            id,
            atsCreateNotesRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateApplicationNoteRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "atsCreateNotesRequestDto", atsCreateNotesRequestDto);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private AtsCreateNotesRequestDto atsCreateNotesRequestDto;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder atsCreateNotesRequestDto(AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
            Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
            this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
            return this;
        }
        
        public AtsCreateApplicationNoteRequest build() {
            return new AtsCreateApplicationNoteRequest(
                xAccountId,
                id,
                atsCreateNotesRequestDto);
        }
    }
}
