/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.SourceValue;
import com.stackone.stackone_client_java.models.components.Value;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class CountryCodeEnum {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends Value> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends SourceValue> sourceValue;

    @JsonCreator
    public CountryCodeEnum(@JsonProperty(value="value") JsonNullable<? extends Value> value, @JsonProperty(value="source_value") JsonNullable<? extends SourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public CountryCodeEnum() {
        this((JsonNullable<? extends Value>)JsonNullable.undefined(), (JsonNullable<? extends SourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<Value> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<SourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CountryCodeEnum withValue(Value value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public CountryCodeEnum withValue(JsonNullable<? extends Value> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public CountryCodeEnum withSourceValue(SourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public CountryCodeEnum withSourceValue(JsonNullable<? extends SourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryCodeEnum other = (CountryCodeEnum)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(CountryCodeEnum.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends Value> value = JsonNullable.undefined();
        private JsonNullable<? extends SourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(Value value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends Value> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(SourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends SourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public CountryCodeEnum build() {
            return new CountryCodeEnum(this.value, this.sourceValue);
        }
    }
}

