/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Url;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class Request {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="method")
    private JsonNullable<String> method;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="headers")
    private JsonNullable<? extends Map<String, Object>> headers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<? extends Url> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private JsonNullable<? extends Object> body;

    @JsonCreator
    public Request(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="method") JsonNullable<String> method, @JsonProperty(value="headers") JsonNullable<? extends Map<String, Object>> headers, @JsonProperty(value="url") JsonNullable<? extends Url> url, @JsonProperty(value="body") JsonNullable<? extends Object> body) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(body, "body");
        this.id = id;
        this.method = method;
        this.headers = headers;
        this.url = url;
        this.body = body;
    }

    public Request() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Url>)JsonNullable.undefined(), (JsonNullable<? extends Object>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> method() {
        return this.method;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return this.headers;
    }

    @JsonIgnore
    public JsonNullable<Url> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<Object> body() {
        return this.body;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Request withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Request withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Request withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = JsonNullable.of((Object)method);
        return this;
    }

    public Request withMethod(JsonNullable<String> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public Request withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public Request withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public Request withUrl(Url url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public Request withUrl(JsonNullable<? extends Url> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Request withBody(Object body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of((Object)body);
        return this;
    }

    public Request withBody(JsonNullable<? extends Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.method, other.method) && Utils.enhancedDeepEquals(this.headers, other.headers) && Utils.enhancedDeepEquals(this.url, other.url) && Utils.enhancedDeepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.method, this.headers, this.url, this.body);
    }

    public String toString() {
        return Utils.toString(Request.class, "id", this.id, "method", this.method, "headers", this.headers, "url", this.url, "body", this.body);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> method = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
        private JsonNullable<? extends Url> url = JsonNullable.undefined();
        private JsonNullable<? extends Object> body = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = JsonNullable.of((Object)method);
            return this;
        }

        public Builder method(JsonNullable<String> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public Builder url(Url url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<? extends Url> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder body(Object body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of((Object)body);
            return this;
        }

        public Builder body(JsonNullable<? extends Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Request build() {
            return new Request(this.id, this.method, this.headers, this.url, this.body);
        }
    }
}

