/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InterviewsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListInterviewsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InterviewsPaginated> interviewsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListInterviewsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InterviewsPaginated> interviewsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(interviewsPaginated, "interviewsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.interviewsPaginated = interviewsPaginated;
        this.headers = headers;
    }

    public AtsListInterviewsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InterviewsPaginated> interviewsPaginated() {
        return this.interviewsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListInterviewsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListInterviewsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListInterviewsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListInterviewsResponse withInterviewsPaginated(InterviewsPaginated interviewsPaginated) {
        Utils.checkNotNull(interviewsPaginated, "interviewsPaginated");
        this.interviewsPaginated = Optional.ofNullable(interviewsPaginated);
        return this;
    }

    public AtsListInterviewsResponse withInterviewsPaginated(Optional<? extends InterviewsPaginated> interviewsPaginated) {
        Utils.checkNotNull(interviewsPaginated, "interviewsPaginated");
        this.interviewsPaginated = interviewsPaginated;
        return this;
    }

    public AtsListInterviewsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListInterviewsResponse other = (AtsListInterviewsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.interviewsPaginated, other.interviewsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.interviewsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListInterviewsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "interviewsPaginated", this.interviewsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InterviewsPaginated> interviewsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder interviewsPaginated(InterviewsPaginated interviewsPaginated) {
            Utils.checkNotNull(interviewsPaginated, "interviewsPaginated");
            this.interviewsPaginated = Optional.ofNullable(interviewsPaginated);
            return this;
        }

        public Builder interviewsPaginated(Optional<? extends InterviewsPaginated> interviewsPaginated) {
            Utils.checkNotNull(interviewsPaginated, "interviewsPaginated");
            this.interviewsPaginated = interviewsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListInterviewsResponse build() {
            return new AtsListInterviewsResponse(this.contentType, this.statusCode, this.rawResponse, this.interviewsPaginated, this.headers);
        }
    }
}

