/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ConnectSession;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneAuthenticateConnectSessionResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ConnectSession> connectSession;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneAuthenticateConnectSessionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ConnectSession> connectSession, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(connectSession, "connectSession");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.connectSession = connectSession;
        this.headers = headers;
    }

    public StackoneAuthenticateConnectSessionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ConnectSession> connectSession() {
        return this.connectSession;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public StackoneAuthenticateConnectSessionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse withConnectSession(ConnectSession connectSession) {
        Utils.checkNotNull(connectSession, "connectSession");
        this.connectSession = Optional.ofNullable(connectSession);
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse withConnectSession(Optional<? extends ConnectSession> connectSession) {
        Utils.checkNotNull(connectSession, "connectSession");
        this.connectSession = connectSession;
        return this;
    }

    public StackoneAuthenticateConnectSessionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneAuthenticateConnectSessionResponse other = (StackoneAuthenticateConnectSessionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.connectSession, other.connectSession) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.connectSession, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneAuthenticateConnectSessionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "connectSession", this.connectSession, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ConnectSession> connectSession = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder connectSession(ConnectSession connectSession) {
            Utils.checkNotNull(connectSession, "connectSession");
            this.connectSession = Optional.ofNullable(connectSession);
            return this;
        }

        public Builder connectSession(Optional<? extends ConnectSession> connectSession) {
            Utils.checkNotNull(connectSession, "connectSession");
            this.connectSession = connectSession;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneAuthenticateConnectSessionResponse build() {
            return new StackoneAuthenticateConnectSessionResponse(this.contentType, this.statusCode, this.rawResponse, this.connectSession, this.headers);
        }
    }
}

