/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BackgroundCheckResultsResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetBackgroundCheckResultResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BackgroundCheckResultsResult> backgroundCheckResultsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetBackgroundCheckResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BackgroundCheckResultsResult> backgroundCheckResultsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(backgroundCheckResultsResult, "backgroundCheckResultsResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.backgroundCheckResultsResult = backgroundCheckResultsResult;
        this.headers = headers;
    }

    public AtsGetBackgroundCheckResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BackgroundCheckResultsResult> backgroundCheckResultsResult() {
        return this.backgroundCheckResultsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetBackgroundCheckResultResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetBackgroundCheckResultResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetBackgroundCheckResultResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetBackgroundCheckResultResponse withBackgroundCheckResultsResult(BackgroundCheckResultsResult backgroundCheckResultsResult) {
        Utils.checkNotNull(backgroundCheckResultsResult, "backgroundCheckResultsResult");
        this.backgroundCheckResultsResult = Optional.ofNullable(backgroundCheckResultsResult);
        return this;
    }

    public AtsGetBackgroundCheckResultResponse withBackgroundCheckResultsResult(Optional<? extends BackgroundCheckResultsResult> backgroundCheckResultsResult) {
        Utils.checkNotNull(backgroundCheckResultsResult, "backgroundCheckResultsResult");
        this.backgroundCheckResultsResult = backgroundCheckResultsResult;
        return this;
    }

    public AtsGetBackgroundCheckResultResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetBackgroundCheckResultResponse other = (AtsGetBackgroundCheckResultResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.backgroundCheckResultsResult, other.backgroundCheckResultsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckResultsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetBackgroundCheckResultResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "backgroundCheckResultsResult", this.backgroundCheckResultsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BackgroundCheckResultsResult> backgroundCheckResultsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder backgroundCheckResultsResult(BackgroundCheckResultsResult backgroundCheckResultsResult) {
            Utils.checkNotNull(backgroundCheckResultsResult, "backgroundCheckResultsResult");
            this.backgroundCheckResultsResult = Optional.ofNullable(backgroundCheckResultsResult);
            return this;
        }

        public Builder backgroundCheckResultsResult(Optional<? extends BackgroundCheckResultsResult> backgroundCheckResultsResult) {
            Utils.checkNotNull(backgroundCheckResultsResult, "backgroundCheckResultsResult");
            this.backgroundCheckResultsResult = backgroundCheckResultsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetBackgroundCheckResultResponse build() {
            return new AtsGetBackgroundCheckResultResponse(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckResultsResult, this.headers);
        }
    }
}

