/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentSuperType;
import com.syntaxphoenix.syntaxapi.command.ArgumentType;
import com.syntaxphoenix.syntaxapi.command.BaseArgument;
import com.syntaxphoenix.syntaxapi.command.NumberEnum;
import com.syntaxphoenix.syntaxapi.command.NumericArgument;
import com.syntaxphoenix.syntaxapi.utils.java.Primitives;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ArgumentMap {
    public static final ArgumentMap EMPTY = new ArgumentMap(Collections.emptyMap());
    protected final Map<String, BaseArgument> arguments = Collections.synchronizedMap(new HashMap());
    private final boolean locked;

    public ArgumentMap() {
        this.locked = true;
    }

    public ArgumentMap(Map<String, BaseArgument> arguments) {
        this.arguments.putAll(arguments);
        this.locked = false;
    }

    final Map<String, BaseArgument> getHandle() {
        return this.arguments;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final boolean set(String key, BaseArgument value) {
        return !this.locked && !this.arguments.containsKey(key) && this.arguments.put(key, value) == null;
    }

    public final Optional<BaseArgument> get(String key) {
        return Optional.ofNullable(this.arguments.get(key));
    }

    public final Optional<BaseArgument> get(String key, ArgumentType type) {
        return this.get(key).filter(argument -> argument.getType() == type);
    }

    public final Optional<BaseArgument> get(String key, ArgumentSuperType type) {
        return this.get(key).filter(argument -> argument.getSuperType() == type);
    }

    public final <E extends Number> Optional<E> number(String key, E sample) {
        return this.number(key, sample.getClass());
    }

    public final <E extends Number> Optional<E> number(String key, Class<E> sample) {
        Optional<BaseArgument> optional = this.get(key, ArgumentSuperType.NUMBER);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        Optional<NumberEnum> option = NumberEnum.of(sample);
        if (!option.isPresent()) {
            return Optional.empty();
        }
        NumericArgument argument = optional.get().asNumeric();
        boolean primitive = Primitives.isPrimitive(sample);
        switch (option.get()) {
            case BYTE: {
                if (argument.getType() == ArgumentType.BYTE) {
                    return this.option(primitive ? argument.asByte().getValue().byteValue() : argument.asByte().getValue().byteValue(), sample);
                }
                byte value = argument.asNumber().byteValue();
                return this.option(primitive ? value : Byte.valueOf(value), sample);
            }
            case SHORT: {
                if (argument.getType() == ArgumentType.SHORT) {
                    return this.option(primitive ? argument.asShort().getValue().shortValue() : argument.asShort().getValue().shortValue(), sample);
                }
                short value0 = argument.asNumber().shortValue();
                return this.option(primitive ? value0 : Short.valueOf(value0), sample);
            }
            case INTEGER: {
                if (argument.getType() == ArgumentType.INTEGER) {
                    return this.option(primitive ? argument.asInteger().getValue().intValue() : argument.asInteger().getValue().intValue(), sample);
                }
                int value1 = argument.asNumber().intValue();
                return this.option(primitive ? value1 : Integer.valueOf(value1), sample);
            }
            case LONG: {
                if (argument.getType() == ArgumentType.LONG) {
                    return this.option(primitive ? argument.asLong().getValue().longValue() : argument.asLong().getValue().longValue(), sample);
                }
                long value2 = argument.asNumber().longValue();
                return this.option(primitive ? value2 : Long.valueOf(value2), sample);
            }
            case FLOAT: {
                if (argument.getType() == ArgumentType.FLOAT) {
                    return this.option(Float.valueOf(primitive ? argument.asFloat().getValue().floatValue() : argument.asFloat().getValue().floatValue()), sample);
                }
                float value3 = argument.asNumber().floatValue();
                return this.option(Float.valueOf(primitive ? value3 : Float.valueOf(value3).floatValue()), sample);
            }
            case DOUBLE: {
                if (argument.getType() == ArgumentType.DOUBLE) {
                    return this.option(primitive ? argument.asDouble().getValue().doubleValue() : argument.asDouble().getValue().doubleValue(), sample);
                }
                double value4 = argument.asNumber().doubleValue();
                return this.option(primitive ? value4 : Double.valueOf(value4), sample);
            }
            case BIG_INTEGER: {
                return Optional.of(argument.getType() == ArgumentType.BIG_INTEGER ? argument.asBigInteger().getValue() : new BigInteger(argument.asNumber().toString()));
            }
            case BIG_DECIMAL: {
                return Optional.of(argument.getType() == ArgumentType.BIG_DECIMAL ? argument.asBigDecimal().getValue() : new BigDecimal(argument.asNumber().toString()));
            }
        }
        return Optional.empty();
    }

    private final <T, E> Optional<E> option(T value, Class<E> sample) {
        return Optional.of(value).map(internal -> internal);
    }
}

