/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.command;

import com.syntaxphoenix.syntaxapi.command.ArgumentRangeSerializer;
import com.syntaxphoenix.syntaxapi.command.ArgumentSerializer;
import com.syntaxphoenix.syntaxapi.command.BaseArgumentRange;
import com.syntaxphoenix.syntaxapi.command.RangeSuperType;
import com.syntaxphoenix.syntaxapi.command.RangeType;
import com.syntaxphoenix.syntaxapi.exception.ObjectLockedException;
import java.util.ArrayList;
import java.util.Iterator;

public class Ranges
implements Iterable<BaseArgumentRange> {
    private final ArrayList<BaseArgumentRange> ranges;
    private boolean locked = false;

    public Ranges() {
        this.ranges = new ArrayList();
    }

    public Ranges(ArrayList<BaseArgumentRange> ranges) {
        this.ranges = ranges;
    }

    public int count() {
        return this.ranges.size();
    }

    public BaseArgumentRange get(int position) {
        if (position < 1) {
            throw this.negativeOrZero();
        }
        if (position > this.count()) {
            throw this.outOfBounce(position);
        }
        return this.ranges.get(position - 1);
    }

    public void add(BaseArgumentRange argument, int position) {
        if (this.locked) {
            throw this.locked();
        }
        if (position < 1) {
            throw this.negativeOrZero();
        }
        if (argument == null) {
            return;
        }
        this.ranges.add(position - 1, argument);
    }

    public void add(BaseArgumentRange argument) {
        if (this.locked) {
            throw this.locked();
        }
        if (argument == null) {
            return;
        }
        this.ranges.add(argument);
    }

    public Class<?> getInputType(int position) {
        return this.get(position).getInputType();
    }

    public RangeType getType(int position) {
        return this.get(position).getType();
    }

    public RangeSuperType getSuperType(int position) {
        return this.getType(position).getSuperType();
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String toString() {
        return this.toString(ArgumentSerializer.DEFAULT);
    }

    public String toString(ArgumentSerializer serializer) {
        return this.toString(ArgumentRangeSerializer.DEFAULT, serializer);
    }

    public String toString(ArgumentRangeSerializer serializer) {
        return this.toString(serializer, ArgumentSerializer.DEFAULT);
    }

    public String toString(ArgumentRangeSerializer range, ArgumentSerializer argument) {
        return null;
    }

    private IllegalArgumentException negativeOrZero() {
        return new IllegalArgumentException("Bound must be positive!");
    }

    private IndexOutOfBoundsException outOfBounce(int position) {
        return new IndexOutOfBoundsException("Index: " + position + " - Size: " + this.count());
    }

    private ObjectLockedException locked() {
        return new ObjectLockedException("Cannot edit a locked object!");
    }

    @Override
    public Iterator<BaseArgumentRange> iterator() {
        return this.ranges.iterator();
    }
}

