/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.data;

import com.syntaxphoenix.syntaxapi.data.DataAdapterContext;
import com.syntaxphoenix.syntaxapi.data.DataType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public class DataTypeChain<P, C>
implements DataType<P, C> {
    private final ArrayList<DataType<?, ?>> types = new ArrayList();

    public boolean has(DataType<?, ?> type) {
        return this.hasExact(type) || this.hasComplex(type.getComplex());
    }

    public boolean hasExact(DataType<?, ?> type) {
        return this.types.contains(type);
    }

    public boolean hasComplex(Class<?> complex) {
        return this.types.stream().anyMatch(type -> Objects.equals(type.getComplex(), complex));
    }

    public DataTypeChain<P, C> add(DataType<?, ?> type) {
        if (type == null) {
            return this;
        }
        if (this.has(type)) {
            return this;
        }
        this.types.add(type);
        return this;
    }

    public DataTypeChain<P, C> addAll(DataType<?, ?> ... types) {
        if (types == null) {
            return this;
        }
        for (int index = 0; index < types.length; ++index) {
            this.add(types[index]);
        }
        return this;
    }

    public DataTypeChain<P, C> addAll(Iterable<DataType<?, ?>> types) {
        if (types == null) {
            return this;
        }
        return this.addAll(types.iterator());
    }

    public DataTypeChain<P, C> addAll(Iterator<DataType<?, ?>> types) {
        if (types == null) {
            return this;
        }
        while (types.hasNext()) {
            this.add(types.next());
        }
        return this;
    }

    public DataTypeChain<P, C> remove(DataType<?, ?> type) {
        this.types.remove(type);
        return this;
    }

    public DataTypeChain<P, C> removeAll(DataType<?, ?> ... types) {
        if (types == null) {
            return this;
        }
        for (int index = 0; index < types.length; ++index) {
            this.remove(types[index]);
        }
        return this;
    }

    public DataTypeChain<P, C> removeAll(Iterable<DataType<?, ?>> types) {
        if (types == null) {
            return this;
        }
        return this.removeAll(types.iterator());
    }

    public DataTypeChain<P, C> removeAll(Iterator<DataType<?, ?>> types) {
        if (types == null) {
            return this;
        }
        while (types.hasNext()) {
            this.remove(types.next());
        }
        return this;
    }

    public DataType<?, ?> get(int index) {
        return this.types.get(index);
    }

    public DataType<?, ?>[] get(int start, int length) {
        return this.types.subList(start, start + length).toArray(new DataType[0]);
    }

    public int size() {
        return this.types.size();
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public DataTypeChain<P, C> clear() {
        this.types.clear();
        return this;
    }

    public <T> Optional<DataTypeChain<P, T>> asComplex(Class<T> complex) {
        return Optional.ofNullable(Objects.equals(this.getComplex(), complex) ? this : null);
    }

    public <T> Optional<DataTypeChain<T, C>> asPrimitive(Class<T> primitive) {
        return Optional.ofNullable(Objects.equals(this.getPrimitive(), primitive) ? this : null);
    }

    @Override
    public Class<C> getComplex() {
        return this.isEmpty() ? null : this.types.get(this.size() - 1).getComplex();
    }

    @Override
    public Class<P> getPrimitive() {
        return this.isEmpty() ? null : this.types.get(0).getPrimitive();
    }

    @Override
    public C fromPrimitive(DataAdapterContext context, P primitive) {
        Object output = primitive;
        for (int index = this.size() - 1; index > -1; --index) {
            if (output == null) {
                return null;
            }
            output = this.types.get(index).fromPrimitiveObj(context, output);
        }
        return (C)(this.isComplex(output) ? output : null);
    }

    @Override
    public P toPrimitive(DataAdapterContext context, C complex) {
        Object output = complex;
        for (int index = this.size() - 1; index > -1; --index) {
            if (output == null) {
                return null;
            }
            output = this.types.get(index).toPrimitiveObj(context, output);
        }
        return (P)(this.isPrimitive(output) ? output : null);
    }
}

