/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.sdk.api.proto.Tq;
import java.io.IOException;
import java.util.Map;

public class TqClientException
extends IOException {
    public final String reason;
    public final Map<String, String> data;
    public final String domain;
    private final Long sequenceId;

    public long getSequenceId() {
        if (this.sequenceId == null) {
            return 0L;
        }
        return this.sequenceId;
    }

    public String getDomain() {
        return this.domain;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getReason() {
        return this.reason;
    }

    public TqClientException(String msg) {
        super(msg);
        this.reason = msg;
        this.domain = "com.turtlequeue";
        this.data = null;
        this.sequenceId = 0L;
    }

    public TqClientException(String msg, Throwable t) {
        super(msg, t);
        this.reason = msg;
        this.domain = "com.turtlequeue";
        this.data = null;
        this.sequenceId = 0L;
    }

    public TqClientException(Tq.ReplyError err) {
        super(err.getErrorInfo().getReason());
        Tq.ErrorInfo errorInfo = err.getErrorInfo();
        this.reason = errorInfo.getReason();
        this.domain = errorInfo.getDomain();
        this.data = errorInfo.getMetadataMap();
        this.sequenceId = err.getSequenceId();
    }

    public TqClientException(Tq.ReplyError err, Throwable t) {
        super(err.getErrorInfo().getReason(), t);
        Tq.ErrorInfo errorInfo = err.getErrorInfo();
        this.reason = errorInfo.getReason();
        this.domain = errorInfo.getDomain();
        this.data = errorInfo.getMetadataMap();
        this.sequenceId = err.getSequenceId();
    }

    protected static TqClientException makeTqExceptionFromReplyError(Tq.ReplyError err) {
        switch (err.getKnownError()) {
            case ALREADY_CLOSED_EXCEPTION: {
                return new AlreadyClosedException(err);
            }
            case AUTHENTICATION_EXCEPTION: {
                return new AuthenticationException(err);
            }
            case AUTHORIZATION_EXCEPTION: {
                return new AuthorizationException(err);
            }
            case BROKER_METADATA_EXCEPTION: {
                return new BrokerMetadataException(err);
            }
            case BROKER_PERSISTENCE_EXCEPTION: {
                return new BrokerPersistenceException(err);
            }
            case CHECKSUM_EXCEPTION: {
                return new ChecksumException(err);
            }
            case CONNECT_EXCEPTION: {
                return new ConnectException(err);
            }
            case CONSUMER_ASSIGN_EXCEPTION: {
                return new ConsumerAssignException(err);
            }
            case CONSUMER_BUSY_EXCEPTION: {
                return new ConsumerBusyException(err);
            }
            case CRYPTO_EXCEPTION: {
                return new CryptoException(err);
            }
            case GETTING_AUTHENTICATION_DATA_EXCEPTION: {
                return new GettingAuthenticationDataException(err);
            }
            case INCOMPATIBLE_SCHEMA_EXCEPTION: {
                return new IncompatibleSchemaException(err);
            }
            case INVALID_CONFIGURATION_EXCEPTION: {
                return new InvalidConfigurationException(err);
            }
            case INVALID_MESSAGE_EXCEPTION: {
                return new InvalidMessageException(err);
            }
            case INVALID_SERVICE_URL: {
                return new InvalidServiceURL(err);
            }
            case INVALID_TOPIC_NAME_EXCEPTION: {
                return new InvalidTopicNameException(err);
            }
            case LOOKUP_EXCEPTION: {
                return new LookupException(err);
            }
            case MESSAGE_ACKNOWLEDGE_EXCEPTION: {
                return new MessageAcknowledgeException(err);
            }
            case NOT_ALLOWED_EXCEPTION: {
                return new NotAllowedException(err);
            }
            case NOT_CONNECTED_EXCEPTION: {
                return new NotConnectedException(err);
            }
            case NOT_FOUND_EXCEPTION: {
                return new NotFoundException(err);
            }
            case NOT_SUPPORTED_EXCEPTION: {
                return new NotSupportedException(err);
            }
            case PRODUCER_BLOCKED_QUOTA_EXCEEDED_ERROR: {
                return new ProducerBlockedQuotaExceededError(err);
            }
            case PRODUCER_BLOCKED_QUOTA_EXCEEDED_EXCEPTION: {
                return new ProducerBlockedQuotaExceededException(err);
            }
            case PRODUCER_BUSY_EXCEPTION: {
                return new ProducerBusyException(err);
            }
            case PRODUCER_QUEUE_IS_FULL_ERROR: {
                return new ProducerQueueIsFullError(err);
            }
            case TIMEOUT_EXCEPTION: {
                return new TimeoutException(err);
            }
            case TOPIC_DOES_NOT_EXIST_EXCEPTION: {
                return new TopicDoesNotExistException(err);
            }
            case TOPIC_TERMINATED_EXCEPTION: {
                return new TopicTerminatedException(err);
            }
            case TRANSACTION_CONFLICT_EXCEPTION: {
                return new TransactionConflictException(err);
            }
            case UNSUPPORTED_AUTHENTICATION_EXCEPTION: {
                return new UnsupportedAuthenticationException(err);
            }
        }
        return new TqClientException(err);
    }

    public static boolean isRetriableError(Throwable t) {
        return !(t instanceof AuthorizationException) && !(t instanceof InvalidServiceURL) && !(t instanceof InvalidConfigurationException) && !(t instanceof NotFoundException) && !(t instanceof IncompatibleSchemaException) && !(t instanceof TopicDoesNotExistException) && !(t instanceof UnsupportedAuthenticationException) && !(t instanceof InvalidMessageException) && !(t instanceof InvalidTopicNameException) && !(t instanceof NotSupportedException) && !(t instanceof NotAllowedException) && !(t instanceof ChecksumException) && !(t instanceof CryptoException) && !(t instanceof ConsumerAssignException) && !(t instanceof MessageAcknowledgeException) && !(t instanceof TransactionConflictException) && !(t instanceof ProducerBusyException) && !(t instanceof ConsumerBusyException);
    }

    public static class UnsupportedAuthenticationException
    extends TqClientException {
        public UnsupportedAuthenticationException(String msg) {
            super(msg);
        }

        public UnsupportedAuthenticationException(String msg, Throwable t) {
            super(msg, t);
        }

        public UnsupportedAuthenticationException(Tq.ReplyError err) {
            super(err);
        }

        public UnsupportedAuthenticationException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class TransactionConflictException
    extends TqClientException {
        public TransactionConflictException(String msg) {
            super(msg);
        }

        public TransactionConflictException(String msg, Throwable t) {
            super(msg, t);
        }

        public TransactionConflictException(Tq.ReplyError err) {
            super(err);
        }

        public TransactionConflictException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class TopicTerminatedException
    extends TqClientException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }

        public TopicTerminatedException(String msg, Throwable t) {
            super(msg, t);
        }

        public TopicTerminatedException(Tq.ReplyError err) {
            super(err);
        }

        public TopicTerminatedException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class TopicDoesNotExistException
    extends TqClientException {
        public TopicDoesNotExistException(String msg) {
            super(msg);
        }

        public TopicDoesNotExistException(String msg, Throwable t) {
            super(msg, t);
        }

        public TopicDoesNotExistException(Tq.ReplyError err) {
            super(err);
        }

        public TopicDoesNotExistException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class TimeoutException
    extends TqClientException {
        public TimeoutException(String msg) {
            super(msg);
        }

        public TimeoutException(String msg, Throwable t) {
            super(msg, t);
        }

        public TimeoutException(Tq.ReplyError err) {
            super(err);
        }

        public TimeoutException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ProducerQueueIsFullError
    extends TqClientException {
        public ProducerQueueIsFullError(String msg) {
            super(msg);
        }

        public ProducerQueueIsFullError(String msg, Throwable t) {
            super(msg, t);
        }

        public ProducerQueueIsFullError(Tq.ReplyError err) {
            super(err);
        }

        public ProducerQueueIsFullError(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ProducerBusyException
    extends TqClientException {
        public ProducerBusyException(String msg) {
            super(msg);
        }

        public ProducerBusyException(String msg, Throwable t) {
            super(msg, t);
        }

        public ProducerBusyException(Tq.ReplyError err) {
            super(err);
        }

        public ProducerBusyException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ProducerBlockedQuotaExceededException
    extends TqClientException {
        public ProducerBlockedQuotaExceededException(String msg) {
            super(msg);
        }

        public ProducerBlockedQuotaExceededException(String msg, Throwable t) {
            super(msg, t);
        }

        public ProducerBlockedQuotaExceededException(Tq.ReplyError err) {
            super(err);
        }

        public ProducerBlockedQuotaExceededException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ProducerBlockedQuotaExceededError
    extends TqClientException {
        public ProducerBlockedQuotaExceededError(String msg) {
            super(msg);
        }

        public ProducerBlockedQuotaExceededError(String msg, Throwable t) {
            super(msg, t);
        }

        public ProducerBlockedQuotaExceededError(Tq.ReplyError err) {
            super(err);
        }

        public ProducerBlockedQuotaExceededError(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class NotSupportedException
    extends TqClientException {
        public NotSupportedException(String msg) {
            super(msg);
        }

        public NotSupportedException(String msg, Throwable t) {
            super(msg, t);
        }

        public NotSupportedException(Tq.ReplyError err) {
            super(err);
        }

        public NotSupportedException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class NotFoundException
    extends TqClientException {
        public NotFoundException(String msg) {
            super(msg);
        }

        public NotFoundException(String msg, Throwable t) {
            super(msg, t);
        }

        public NotFoundException(Tq.ReplyError err) {
            super(err);
        }

        public NotFoundException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class NotConnectedException
    extends TqClientException {
        public NotConnectedException(String msg) {
            super(msg);
        }

        public NotConnectedException(String msg, Throwable t) {
            super(msg, t);
        }

        public NotConnectedException(Tq.ReplyError err) {
            super(err);
        }

        public NotConnectedException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class NotAllowedException
    extends TqClientException {
        public NotAllowedException(String msg) {
            super(msg);
        }

        public NotAllowedException(String msg, Throwable t) {
            super(msg, t);
        }

        public NotAllowedException(Tq.ReplyError err) {
            super(err);
        }

        public NotAllowedException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class MessageAcknowledgeException
    extends TqClientException {
        public MessageAcknowledgeException(String msg) {
            super(msg);
        }

        public MessageAcknowledgeException(String msg, Throwable t) {
            super(msg, t);
        }

        public MessageAcknowledgeException(Tq.ReplyError err) {
            super(err);
        }

        public MessageAcknowledgeException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class LookupException
    extends TqClientException {
        public LookupException(String msg) {
            super(msg);
        }

        public LookupException(String msg, Throwable t) {
            super(msg, t);
        }

        public LookupException(Tq.ReplyError err) {
            super(err);
        }

        public LookupException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class InvalidTopicNameException
    extends TqClientException {
        public InvalidTopicNameException(String msg) {
            super(msg);
        }

        public InvalidTopicNameException(String msg, Throwable t) {
            super(msg, t);
        }

        public InvalidTopicNameException(Tq.ReplyError err) {
            super(err);
        }

        public InvalidTopicNameException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class InvalidServiceURL
    extends TqClientException {
        public InvalidServiceURL(String msg) {
            super(msg);
        }

        public InvalidServiceURL(String msg, Throwable t) {
            super(msg, t);
        }

        public InvalidServiceURL(Tq.ReplyError err) {
            super(err);
        }

        public InvalidServiceURL(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class InvalidMessageException
    extends TqClientException {
        public InvalidMessageException(String msg) {
            super(msg);
        }

        public InvalidMessageException(String msg, Throwable t) {
            super(msg, t);
        }

        public InvalidMessageException(Tq.ReplyError err) {
            super(err);
        }

        public InvalidMessageException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class InvalidConfigurationException
    extends TqClientException {
        public InvalidConfigurationException(String msg) {
            super(msg);
        }

        public InvalidConfigurationException(String msg, Throwable t) {
            super(msg, t);
        }

        public InvalidConfigurationException(Tq.ReplyError err) {
            super(err);
        }

        public InvalidConfigurationException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class IncompatibleSchemaException
    extends TqClientException {
        public IncompatibleSchemaException(String msg) {
            super(msg);
        }

        public IncompatibleSchemaException(String msg, Throwable t) {
            super(msg, t);
        }

        public IncompatibleSchemaException(Tq.ReplyError err) {
            super(err);
        }

        public IncompatibleSchemaException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class GettingAuthenticationDataException
    extends TqClientException {
        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }

        public GettingAuthenticationDataException(String msg, Throwable t) {
            super(msg, t);
        }

        public GettingAuthenticationDataException(Tq.ReplyError err) {
            super(err);
        }

        public GettingAuthenticationDataException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class CryptoException
    extends TqClientException {
        public CryptoException(String msg) {
            super(msg);
        }

        public CryptoException(String msg, Throwable t) {
            super(msg, t);
        }

        public CryptoException(Tq.ReplyError err) {
            super(err);
        }

        public CryptoException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ConsumerBusyException
    extends TqClientException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }

        public ConsumerBusyException(String msg, Throwable t) {
            super(msg, t);
        }

        public ConsumerBusyException(Tq.ReplyError err) {
            super(err);
        }

        public ConsumerBusyException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ConsumerAssignException
    extends TqClientException {
        public ConsumerAssignException(String msg) {
            super(msg);
        }

        public ConsumerAssignException(String msg, Throwable t) {
            super(msg, t);
        }

        public ConsumerAssignException(Tq.ReplyError err) {
            super(err);
        }

        public ConsumerAssignException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ConnectException
    extends TqClientException {
        public ConnectException(String msg) {
            super(msg);
        }

        public ConnectException(String msg, Throwable t) {
            super(msg, t);
        }

        public ConnectException(Tq.ReplyError err) {
            super(err);
        }

        public ConnectException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class ChecksumException
    extends TqClientException {
        public ChecksumException(String msg) {
            super(msg);
        }

        public ChecksumException(String msg, Throwable t) {
            super(msg, t);
        }

        public ChecksumException(Tq.ReplyError err) {
            super(err);
        }

        public ChecksumException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class BrokerPersistenceException
    extends TqClientException {
        public BrokerPersistenceException(String msg) {
            super(msg);
        }

        public BrokerPersistenceException(String msg, Throwable t) {
            super(msg, t);
        }

        public BrokerPersistenceException(Tq.ReplyError err) {
            super(err);
        }

        public BrokerPersistenceException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class BrokerMetadataException
    extends TqClientException {
        public BrokerMetadataException(String msg) {
            super(msg);
        }

        public BrokerMetadataException(String msg, Throwable t) {
            super(msg, t);
        }

        public BrokerMetadataException(Tq.ReplyError err) {
            super(err);
        }

        public BrokerMetadataException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class AuthorizationException
    extends TqClientException {
        public AuthorizationException(String msg) {
            super(msg);
        }

        public AuthorizationException(String msg, Throwable t) {
            super(msg, t);
        }

        public AuthorizationException(Tq.ReplyError err) {
            super(err);
        }

        public AuthorizationException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class AuthenticationException
    extends TqClientException {
        public AuthenticationException(String msg) {
            super(msg);
        }

        public AuthenticationException(String msg, Throwable t) {
            super(msg, t);
        }

        public AuthenticationException(Tq.ReplyError err) {
            super(err);
        }

        public AuthenticationException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }

    public static class AlreadyClosedException
    extends TqClientException {
        public AlreadyClosedException(String msg) {
            super(msg);
        }

        public AlreadyClosedException(String msg, Throwable t) {
            super(msg, t);
        }

        public AlreadyClosedException(Tq.ReplyError err) {
            super(err);
        }

        public AlreadyClosedException(Tq.ReplyError err, Throwable t) {
            super(err, t);
        }
    }
}

