/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.ClientImpl;
import com.turtlequeue.Consumer;
import com.turtlequeue.ConsumerImpl;
import com.turtlequeue.Message;
import com.turtlequeue.MessageId;
import com.turtlequeue.MessageIdImpl;
import com.turtlequeue.sdk.api.proto.Tq;
import java.util.concurrent.CompletableFuture;

public class AcknowledgeBuilder {
    ClientImpl c = null;
    ConsumerImpl consumer = null;
    MessageId messageId = null;
    AckType ackType = null;
    boolean negativeAcknowledge;

    public AcknowledgeBuilder(ClientImpl c) {
        this.c = c;
        this.ackType = AckType.Individual;
    }

    public AcknowledgeBuilder setMessage(Message message) {
        this.messageId = message.getMessageId();
        return this;
    }

    public AcknowledgeBuilder setConsumer(Consumer consumer) {
        this.consumer = (ConsumerImpl)consumer;
        return this;
    }

    public AcknowledgeBuilder setMessageId(MessageId messageId) {
        this.messageId = messageId;
        return this;
    }

    public AcknowledgeBuilder setAckType(AckType ackType) {
        this.ackType = ackType;
        return this;
    }

    public AcknowledgeBuilder setNegativeAck(boolean b) {
        this.negativeAcknowledge = b;
        return this;
    }

    public CompletableFuture<Void> nack() {
        this.negativeAcknowledge = true;
        return this.send();
    }

    public CompletableFuture<Void> ack() {
        this.negativeAcknowledge = false;
        return this.send();
    }

    public CompletableFuture<Void> send() {
        Tq.CommandAck.AckType ack;
        if (this.messageId == null) {
            throw new IllegalArgumentException(".setMessage or .setMessageId must be called before acknowledging");
        }
        if (this.consumer == null) {
            throw new IllegalArgumentException(".setConsumer must be called before acknowledging");
        }
        switch (this.ackType) {
            case Individual: {
                ack = Tq.CommandAck.AckType.INDIVIDUAL;
                break;
            }
            case Cumulative: {
                ack = Tq.CommandAck.AckType.CUMULATIVE;
                break;
            }
            default: {
                ack = Tq.CommandAck.AckType.INDIVIDUAL;
            }
        }
        return this.c.consumerCommand(Tq.CommandConsumer.newBuilder().setConsumerId(this.consumer.getConsumerId().longValue()).setCommandAck(Tq.CommandAck.newBuilder().setAckType(ack).setMessageId(MessageIdImpl.toMessageIdData(this.messageId)).setNegativeAck(this.negativeAcknowledge).build()).build());
    }

    public static enum AckType {
        Individual,
        Cumulative;

    }
}

