/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.sdk.api.proto.TurtleQueueGrpc;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class AuthenticationCallCredentials
extends CallCredentials {
    private static final Logger logger = Logger.getLogger(TurtleQueueGrpc.class.getName());
    private String userToken;
    private String apiKey;
    private String authMethod;
    private String dataFormat;
    private String sdkVersion;
    private static Metadata.Key<String> META_DATA_USER_TOKEN = Metadata.Key.of((String)"UserToken", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static Metadata.Key<String> META_DATA_API_KEY = Metadata.Key.of((String)"ApiKey", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static Metadata.Key<String> META_DATA_AUTH_METHOD = Metadata.Key.of((String)"AuthMethod", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static Metadata.Key<String> META_DATA_DATA_FORMAT = Metadata.Key.of((String)"DataFormat", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static Metadata.Key<String> META_DATA_SDK_VERSION = Metadata.Key.of((String)"SdkVersion", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public AuthenticationCallCredentials(String userToken, String apiKey, String authMethod, String dataFormat, String sdkVersion) {
        this.userToken = userToken;
        this.apiKey = apiKey;
        this.authMethod = authMethod;
        this.dataFormat = dataFormat;
        this.sdkVersion = sdkVersion;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        AuthenticationCallCredentials thisRef = this;
        executor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                if (thisRef.authMethod != null) {
                    headers.put(META_DATA_AUTH_METHOD, (Object)thisRef.authMethod);
                }
                headers.put(META_DATA_USER_TOKEN, (Object)thisRef.userToken);
                headers.put(META_DATA_API_KEY, (Object)thisRef.apiKey);
                if (thisRef.dataFormat != null) {
                    headers.put(META_DATA_DATA_FORMAT, (Object)thisRef.dataFormat);
                }
                if (thisRef.sdkVersion != null) {
                    headers.put(META_DATA_SDK_VERSION, (Object)thisRef.sdkVersion);
                }
                metadataApplier.apply(headers);
            }
            catch (Throwable e) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

