/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.google.common.collect.ComparisonChain;
import com.turtlequeue.MessageId;
import com.turtlequeue.sdk.api.proto.Tq;

public class MessageIdImpl
implements MessageId {
    protected final long ledgerId;
    protected final long entryId;
    protected final int partitionIndex;

    public MessageIdImpl(long ledgerId, long entryId, int partitionIndex) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.partitionIndex = partitionIndex;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int hashCode() {
        return (int)(31L * (this.ledgerId + 31L * this.entryId) + (long)this.partitionIndex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("%d:%d:%d", this.ledgerId, this.entryId, this.partitionIndex);
    }

    @Override
    public int compareTo(MessageId o) {
        if (o instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)o;
            return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
        }
        throw new IllegalArgumentException("expected MessageIdImpl object. Got instance of " + o.getClass().getName());
    }

    protected static MessageIdImpl fromMessageIdData(Tq.MessageIdData msg) {
        return new MessageIdImpl(msg.getLedgerId(), msg.getEntryId(), msg.getPartition());
    }

    protected static Tq.MessageIdData toMessageIdData(MessageId msg) {
        return Tq.MessageIdData.newBuilder().setLedgerId(msg.getLedgerId()).setEntryId(msg.getEntryId()).setPartition(msg.getPartitionIndex()).build();
    }
}

