/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.carshop;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.jsf.sample.carshop.CarPool;
import de.beyondjava.jsf.sample.carshop.DynamicOptionBean;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.event.AjaxBehaviorEvent;

@ManagedBean
@SessionScoped
public class FilterBean
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.jsf.sample.carshop.FilterBean");
    private String brand;
    @ManagedProperty(value="#{carPool}")
    private transient CarPool carPool;
    private String color;
    @ManagedProperty(value="#{dynamicOptionBean}")
    private DynamicOptionBean dynamicOptions;
    private String fuel;
    private String mileage;
    private String price;
    private String type;
    private String yearText;

    public void doFilter(AjaxBehaviorEvent event) {
        LOGGER.info("doFilter called");
    }

    public String doFilterAction() {
        LOGGER.info("doFilterAction called");
        return null;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getColor() {
        return this.color;
    }

    @JsonIgnore
    public String getCounter() {
        this.initIfNecessary();
        this.carPool.applyFilter(this);
        long l = this.carPool.getSelectedCars().size();
        return String.valueOf(l);
    }

    public DynamicOptionBean getDynamicOptions() {
        return this.dynamicOptions;
    }

    public String getFuel() {
        return this.fuel;
    }

    public String getMileage() {
        return this.mileage;
    }

    public String getPrice() {
        return this.price;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public List<String> getTypes() {
        this.initIfNecessary();
        return this.dynamicOptions.getTypesToBrand(this.brand);
    }

    public int getYear() {
        if (this.yearText == null || this.yearText.length() < 4) {
            return 0;
        }
        try {
            String year = this.yearText.substring(0, 4);
            return Integer.parseInt(year);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getYearText() {
        return this.yearText;
    }

    private void initIfNecessary() {
        if (null == this.dynamicOptions) {
            this.dynamicOptions = (DynamicOptionBean)ELTools.evalAsObject((String)"#{dynamicOptionBean}");
        }
        if (null == this.carPool) {
            this.carPool = (CarPool)ELTools.evalAsObject((String)"#{carPool}");
        }
    }

    public void setBrand(String brand) {
        this.brand = brand;
        if (brand != null && this.type != null && this.type.length() > 0) {
            this.initIfNecessary();
            if (!brand.equals(this.dynamicOptions.getBrandToType(this.type))) {
                this.type = null;
            }
        }
        if (null != this.dynamicOptions) {
            this.dynamicOptions.setBrandAndType(brand, this.type);
        }
    }

    public void setCarPool(CarPool carPool) {
        this.carPool = carPool;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setDynamicOptions(DynamicOptionBean dynamicOptions) {
        this.dynamicOptions = dynamicOptions;
    }

    public void setFuel(String fuel) {
        this.fuel = fuel;
    }

    public void setMileage(String mileage) {
        this.mileage = mileage;
    }

    public void setOptions(DynamicOptionBean options) {
        this.dynamicOptions = options;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setType(String type) {
        this.type = type;
        this.initIfNecessary();
        if (null != this.dynamicOptions) {
            String b = this.dynamicOptions.getBrandToType(type);
            if (null != b && b.length() > 0) {
                this.brand = b;
            }
            this.dynamicOptions.setBrandAndType(this.brand, type);
        }
    }

    public void setYearText(String year) {
        this.yearText = year;
    }
}

