/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.ngTable;

import de.beyondjava.angularFaces.components.puiSync.JSONUtilities;
import de.beyondjava.jsf.sample.ngTable.User;
import de.beyondjava.jsf.sample.ngTable.UsersBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

@ManagedBean
@SessionScoped
public class UsersBean {
    private List<User> users = new ArrayList();

    public UsersBean() {
        this.users.add(new User("Moroni", 50));
        this.users.add(new User("Tiancum", 43));
        this.users.add(new User("Jacob", 27));
        this.users.add(new User("Nephi", 29));
        this.users.add(new User("Enos", 34));
    }

    public String getUsersAsJson() {
        String usersAsJson = JSONUtilities.writeObjectToJSONString((Object)this.users);
        usersAsJson = usersAsJson.replace('\"', '\'');
        return usersAsJson;
    }

    public void setUsers(ArrayList<?> s) {
        if (s == null) {
            this.users = null;
        } else {
            ArrayList<User> result = new ArrayList<User>(s.size());
            for (Object o : s) {
                if (o instanceof User) {
                    result.add((User)o);
                    continue;
                }
                if (!(o instanceof Map)) continue;
                String name = (String)((Map)o).get("name");
                Object ageAsObject = ((Map)o).get("age");
                int age = ageAsObject instanceof String ? Integer.valueOf((String)ageAsObject).intValue() : ((Integer)ageAsObject).intValue();
                User user = new User(name, age);
                result.add(user);
            }
            this.users = result;
        }
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void save(ActionEvent event) {
        String u = "";
        for (User user : this.users) {
            u = u + " ," + user.getName() + "(" + user.getAge() + ")";
        }
        if (u.length() > 0) {
            u = u.substring(2);
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "", "Currently, the server side list contains " + this.users.size() + " users:" + u);
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public void sortAscendingName(ActionEvent even) {
        FacesMessage message = new FacesMessage("Sorting the list ascending by name. The sort algorithm is implemented on the server side.");
        FacesContext.getCurrentInstance().addMessage(null, message);
        1 ascending = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(this.users, ascending);
    }

    public void sortDescendingName(ActionEvent even) {
        FacesMessage message = new FacesMessage("Sorting the list descending by name. The sort algorithm is implemented on the server side.");
        FacesContext.getCurrentInstance().addMessage(null, message);
        2 descending = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(this.users, descending);
    }

    public void sortAscendingAge(ActionEvent even) {
        FacesMessage message = new FacesMessage("Sorting the list ascending by age. The sort algorithm is implemented on the server side.");
        FacesContext.getCurrentInstance().addMessage(null, message);
        3 ascending = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(this.users, ascending);
    }

    public void sortDescendingAge(ActionEvent even) {
        FacesMessage message = new FacesMessage("Sorting the list descending by age. The sort algorithm is implemented on the server side.");
        FacesContext.getCurrentInstance().addMessage(null, message);
        4 descending = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(this.users, descending);
    }
}

