/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable.reader;

import com.google.common.collect.Maps;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.reader.ObservationTableReader;
import de.learnlib.algorithms.features.observationtable.reader.SimpleObservationTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class SuffixASCIIReader<I, D>
implements ObservationTableReader<I, D> {
    private static final String WORD_DELIMITER = ";";
    private static final String SYMBOL_DELIMITER = ",";

    @Override
    public ObservationTable<I, D> read(String source, Alphabet<I> alphabet) {
        Map<String, I> nameToSymbol = this.generateNameToSymbolMap(alphabet);
        String[] suffixWords = source.split(WORD_DELIMITER);
        ArrayList<Word> suffixes = new ArrayList<Word>(suffixWords.length);
        for (String suffixWord : suffixWords) {
            String[] symbolNames = suffixWord.split(SYMBOL_DELIMITER);
            Word word = Word.epsilon();
            if (!suffixWord.isEmpty()) {
                for (String symbolName : symbolNames) {
                    word = word.append(nameToSymbol.get(symbolName));
                }
            }
            suffixes.add(word);
        }
        return new SimpleObservationTable(suffixes);
    }

    private Map<String, I> generateNameToSymbolMap(Alphabet<I> alphabet) {
        HashMap nameToSymbol = Maps.newHashMapWithExpectedSize((int)alphabet.size());
        for (Object symbol : alphabet) {
            String symbolName = symbol.toString();
            if (nameToSymbol.containsKey(symbolName)) {
                throw new IllegalArgumentException("Symbol name '" + symbolName + "' is used more than once in alphabet");
            }
            nameToSymbol.put(symbolName, symbol);
        }
        return nameToSymbol;
    }
}

