/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.features.observationtable.writer;

import com.google.common.base.Function;
import de.learnlib.algorithms.features.observationtable.ObservationTable;
import de.learnlib.algorithms.features.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import net.automatalib.words.Word;

public class ObservationTableHTMLWriter<I, D>
extends AbstractObservationTableWriter<I, D> {
    public ObservationTableHTMLWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) {
        super(wordToString, outputToString);
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends D> table, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        out.append("<table class=\"learnlib-observationtable\">\n");
        out.append("\t<thead>\n");
        out.append("\t\t<tr><th rowspan=\"2\" class=\"prefix\">Prefix</th><th colspan=\"").append(Integer.toString(suffixes.size())).append("\" class=\"suffixes-header\">Suffixes</th></tr>\n");
        out.append("\t\t<tr>");
        for (Word<I> word : suffixes) {
            out.append("<td>").append(this.wordToString(word)).append("</td>");
        }
        out.append("</tr>\n");
        out.append("\t</thead>\n");
        out.append("\t<tbody>\n");
        for (ObservationTable.Row row : table.getShortPrefixRows()) {
            out.append("\t\t<tr class=\"short-prefix\"><td class=\"prefix\">").append(this.wordToString(row.getLabel())).append("</td>");
            for (Object value : row) {
                out.append("<td class=\"suffix-column\">").append(this.outputToString(value)).append("</td>");
            }
            out.append("</tr>\n");
        }
        out.append("\t\t<tr><td colspan=\"").append(Integer.toString(suffixes.size() + 1)).append("\"></td></tr>\n");
        for (ObservationTable.Row row : table.getLongPrefixRows()) {
            out.append("\t\t<tr class=\"long-prefix\"><td>").append(this.wordToString(row.getLabel())).append("</td>");
            for (Object value : row) {
                out.append("<td class=\"suffix-column\">").append(this.outputToString(value)).append("</td>");
            }
            out.append("</tr>\n");
        }
        out.append("</table>\n");
    }
}

