/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.WriteTreeRef;
import com.google.firebase.database.core.operation.Operation;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.core.utilities.Pair;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.DataEvent;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.QueryParams;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.core.view.View;
import com.google.firebase.database.core.view.ViewCache;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SyncPoint {
    private final Map<QueryParams, View> views = new HashMap<QueryParams, View>();
    private final PersistenceManager persistenceManager;

    public SyncPoint(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    private List<DataEvent> applyOperationToView(View view, Operation operation, WriteTreeRef writes, Node optCompleteServerCache) {
        View.OperationResult result = view.applyOperation(operation, writes, optCompleteServerCache);
        if (!view.getQuery().loadsAllData()) {
            HashSet<ChildKey> removed = new HashSet<ChildKey>();
            HashSet<ChildKey> added = new HashSet<ChildKey>();
            for (Change change : result.changes) {
                Event.EventType type = change.getEventType();
                if (type == Event.EventType.CHILD_ADDED) {
                    added.add(change.getChildKey());
                    continue;
                }
                if (type != Event.EventType.CHILD_REMOVED) continue;
                removed.add(change.getChildKey());
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                this.persistenceManager.updateTrackedQueryKeys(view.getQuery(), added, removed);
            }
        }
        return result.events;
    }

    public List<DataEvent> applyOperation(Operation operation, WriteTreeRef writesCache, Node optCompleteServerCache) {
        QueryParams queryParams = operation.getSource().getQueryParams();
        if (queryParams != null) {
            View view = this.views.get(queryParams);
            Utilities.hardAssert(view != null);
            return this.applyOperationToView(view, operation, writesCache, optCompleteServerCache);
        }
        ArrayList<DataEvent> events = new ArrayList<DataEvent>();
        for (Map.Entry<QueryParams, View> entry : this.views.entrySet()) {
            View view = entry.getValue();
            events.addAll(this.applyOperationToView(view, operation, writesCache, optCompleteServerCache));
        }
        return events;
    }

    public View getView(QuerySpec query, WriteTreeRef writesCache, CacheNode serverCache) {
        View view = this.views.get(query.getParams());
        if (view == null) {
            boolean eventCacheComplete;
            Node eventCache = writesCache.calcCompleteEventCache(serverCache.isFullyInitialized() ? serverCache.getNode() : null);
            if (eventCache != null) {
                eventCacheComplete = true;
            } else {
                eventCache = writesCache.calcCompleteEventChildren(serverCache.getNode() != null ? serverCache.getNode() : EmptyNode.Empty());
                eventCacheComplete = false;
            }
            IndexedNode indexed = IndexedNode.from(eventCache, query.getIndex());
            ViewCache viewCache = new ViewCache(new CacheNode(indexed, eventCacheComplete, false), serverCache);
            return new View(query, viewCache);
        }
        return view;
    }

    public List<DataEvent> addEventRegistration(@NotNull EventRegistration eventRegistration, WriteTreeRef writesCache, CacheNode serverCache) {
        QuerySpec query = eventRegistration.getQuerySpec();
        View view = this.getView(query, writesCache, serverCache);
        if (!query.loadsAllData()) {
            HashSet<ChildKey> allChildren = new HashSet<ChildKey>();
            for (NamedNode node : view.getEventCache()) {
                allChildren.add(node.getName());
            }
            this.persistenceManager.setTrackedQueryKeys(query, allChildren);
        }
        if (!this.views.containsKey(query.getParams())) {
            this.views.put(query.getParams(), view);
        }
        this.views.put(query.getParams(), view);
        view.addEventRegistration(eventRegistration);
        return view.getInitialEvents(eventRegistration);
    }

    public Pair<List<QuerySpec>, List<Event>> removeEventRegistration(@NotNull QuerySpec query, @Nullable EventRegistration eventRegistration, @Nullable DatabaseError cancelError) {
        ArrayList<QuerySpec> removed = new ArrayList<QuerySpec>();
        ArrayList<Event> cancelEvents = new ArrayList<Event>();
        boolean hadCompleteView = this.hasCompleteView();
        if (query.isDefault()) {
            Iterator<Map.Entry<QueryParams, View>> iterator = this.views.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<QueryParams, View> entry = iterator.next();
                View view = entry.getValue();
                cancelEvents.addAll(view.removeEventRegistration(eventRegistration, cancelError));
                if (!view.isEmpty()) continue;
                iterator.remove();
                if (view.getQuery().loadsAllData()) continue;
                removed.add(view.getQuery());
            }
        } else {
            View view = this.views.get(query.getParams());
            if (view != null) {
                cancelEvents.addAll(view.removeEventRegistration(eventRegistration, cancelError));
                if (view.isEmpty()) {
                    this.views.remove(query.getParams());
                    if (!view.getQuery().loadsAllData()) {
                        removed.add(view.getQuery());
                    }
                }
            }
        }
        if (hadCompleteView && !this.hasCompleteView()) {
            removed.add(QuerySpec.defaultQueryAtPath(query.getPath()));
        }
        return new Pair<List<QuerySpec>, List<Event>>(removed, cancelEvents);
    }

    public List<View> getQueryViews() {
        ArrayList<View> views = new ArrayList<View>();
        for (Map.Entry<QueryParams, View> entry : this.views.entrySet()) {
            View view = entry.getValue();
            if (view.getQuery().loadsAllData()) continue;
            views.add(view);
        }
        return views;
    }

    public Node getCompleteServerCache(Path path) {
        for (View view : this.views.values()) {
            if (view.getCompleteServerCache(path) == null) continue;
            return view.getCompleteServerCache(path);
        }
        return null;
    }

    public View viewForQuery(QuerySpec query) {
        if (query.loadsAllData()) {
            return this.getCompleteView();
        }
        return this.views.get(query.getParams());
    }

    public boolean viewExistsForQuery(QuerySpec query) {
        return this.viewForQuery(query) != null;
    }

    public boolean hasCompleteView() {
        return this.getCompleteView() != null;
    }

    public View getCompleteView() {
        for (Map.Entry<QueryParams, View> entry : this.views.entrySet()) {
            View view = entry.getValue();
            if (!view.getQuery().loadsAllData()) continue;
            return view;
        }
        return null;
    }

    Map<QueryParams, View> getViews() {
        return this.views;
    }
}

