/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.ComponentProvider;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.local.IndexBackfiller;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.QueryEngine;
import com.google.firebase.firestore.local.Scheduler;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.remote.AndroidConnectivityMonitor;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.RemoteStore;
import io.grpc.Status;

public class MemoryComponentProvider
extends ComponentProvider {
    @Override
    @Nullable
    protected Scheduler createGarbageCollectionScheduler(ComponentProvider.Configuration configuration) {
        return null;
    }

    @Override
    @Nullable
    protected IndexBackfiller createIndexBackfiller(ComponentProvider.Configuration configuration) {
        return null;
    }

    @Override
    protected EventManager createEventManager(ComponentProvider.Configuration configuration) {
        return new EventManager(this.getSyncEngine());
    }

    @Override
    protected LocalStore createLocalStore(ComponentProvider.Configuration configuration) {
        return new LocalStore(this.getPersistence(), this.getIndexBackfiller(), new QueryEngine(), configuration.getInitialUser());
    }

    @Override
    protected AndroidConnectivityMonitor createConnectivityMonitor(ComponentProvider.Configuration configuration) {
        return new AndroidConnectivityMonitor(configuration.getContext());
    }

    @Override
    protected Persistence createPersistence(ComponentProvider.Configuration configuration) {
        return MemoryPersistence.createEagerGcMemoryPersistence();
    }

    @Override
    protected RemoteStore createRemoteStore(ComponentProvider.Configuration configuration) {
        return new RemoteStore(new RemoteStoreCallback(), this.getLocalStore(), configuration.getDatastore(), configuration.getAsyncQueue(), this.getConnectivityMonitor());
    }

    @Override
    protected SyncEngine createSyncEngine(ComponentProvider.Configuration configuration) {
        return new SyncEngine(this.getLocalStore(), this.getRemoteStore(), configuration.getInitialUser(), configuration.getMaxConcurrentLimboResolutions());
    }

    private class RemoteStoreCallback
    implements RemoteStore.RemoteStoreCallback {
        private RemoteStoreCallback() {
        }

        @Override
        public void handleRemoteEvent(RemoteEvent remoteEvent) {
            MemoryComponentProvider.this.getSyncEngine().handleRemoteEvent(remoteEvent);
        }

        @Override
        public void handleRejectedListen(int targetId, Status error) {
            MemoryComponentProvider.this.getSyncEngine().handleRejectedListen(targetId, error);
        }

        @Override
        public void handleSuccessfulWrite(MutationBatchResult mutationBatchResult) {
            MemoryComponentProvider.this.getSyncEngine().handleSuccessfulWrite(mutationBatchResult);
        }

        @Override
        public void handleRejectedWrite(int batchId, Status error) {
            MemoryComponentProvider.this.getSyncEngine().handleRejectedWrite(batchId, error);
        }

        @Override
        public void handleOnlineStateChange(OnlineState onlineState) {
            MemoryComponentProvider.this.getSyncEngine().handleOnlineStateChange(onlineState);
        }

        @Override
        public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int targetId) {
            return MemoryComponentProvider.this.getSyncEngine().getRemoteKeysForTarget(targetId);
        }
    }
}

