/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import com.google.firebase.firestore.core.CompositeFilter;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.StructuredQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LogicUtils {
    private static void assertFieldFilterOrCompositeFilter(Filter filter) {
        Assert.hardAssert(filter instanceof FieldFilter || filter instanceof CompositeFilter, "Only field filters and composite filters are accepted.", new Object[0]);
    }

    private static boolean isSingleFieldFilter(Filter filter) {
        return filter instanceof FieldFilter;
    }

    private static boolean isFlatConjunction(Filter filter) {
        return filter instanceof CompositeFilter && ((CompositeFilter)filter).isFlatConjunction();
    }

    private static boolean isDisjunctionOfFieldFiltersAndFlatConjunctions(Filter filter) {
        CompositeFilter compositeFilter;
        if (filter instanceof CompositeFilter && (compositeFilter = (CompositeFilter)filter).isDisjunction()) {
            for (Filter subfilter : compositeFilter.getFilters()) {
                if (LogicUtils.isSingleFieldFilter(subfilter) || LogicUtils.isFlatConjunction(subfilter)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isDisjunctiveNormalForm(Filter filter) {
        return LogicUtils.isSingleFieldFilter(filter) || LogicUtils.isFlatConjunction(filter) || LogicUtils.isDisjunctionOfFieldFiltersAndFlatConjunctions(filter);
    }

    protected static Filter applyAssociation(Filter filter) {
        LogicUtils.assertFieldFilterOrCompositeFilter(filter);
        if (LogicUtils.isSingleFieldFilter(filter)) {
            return filter;
        }
        CompositeFilter compositeFilter = (CompositeFilter)filter;
        List<Filter> filters = compositeFilter.getFilters();
        if (filters.size() == 1) {
            return LogicUtils.applyAssociation(filters.get(0));
        }
        if (compositeFilter.isFlat()) {
            return compositeFilter;
        }
        ArrayList<Filter> updatedFilters = new ArrayList<Filter>();
        for (Filter subfilter : filters) {
            updatedFilters.add(LogicUtils.applyAssociation(subfilter));
        }
        ArrayList<Filter> newSubfilters = new ArrayList<Filter>();
        for (Filter subfilter : updatedFilters) {
            if (subfilter instanceof FieldFilter) {
                newSubfilters.add(subfilter);
                continue;
            }
            if (!(subfilter instanceof CompositeFilter)) continue;
            CompositeFilter compositeSubfilter = (CompositeFilter)subfilter;
            if (compositeSubfilter.getOperator().equals((Object)compositeFilter.getOperator())) {
                newSubfilters.addAll(compositeSubfilter.getFilters());
                continue;
            }
            newSubfilters.add(compositeSubfilter);
        }
        if (newSubfilters.size() == 1) {
            return (Filter)newSubfilters.get(0);
        }
        return new CompositeFilter(newSubfilters, compositeFilter.getOperator());
    }

    protected static Filter applyDistribution(Filter lhs, Filter rhs) {
        LogicUtils.assertFieldFilterOrCompositeFilter(lhs);
        LogicUtils.assertFieldFilterOrCompositeFilter(rhs);
        Filter result = lhs instanceof FieldFilter && rhs instanceof FieldFilter ? LogicUtils.applyDistribution((FieldFilter)lhs, (FieldFilter)rhs) : (lhs instanceof FieldFilter && rhs instanceof CompositeFilter ? LogicUtils.applyDistribution((FieldFilter)lhs, (CompositeFilter)rhs) : (lhs instanceof CompositeFilter && rhs instanceof FieldFilter ? LogicUtils.applyDistribution((FieldFilter)rhs, (CompositeFilter)lhs) : LogicUtils.applyDistribution((CompositeFilter)lhs, (CompositeFilter)rhs)));
        return LogicUtils.applyAssociation(result);
    }

    private static Filter applyDistribution(FieldFilter lhs, FieldFilter rhs) {
        return new CompositeFilter(Arrays.asList(lhs, rhs), StructuredQuery.CompositeFilter.Operator.AND);
    }

    private static Filter applyDistribution(FieldFilter fieldFilter, CompositeFilter compositeFilter) {
        if (compositeFilter.isConjunction()) {
            return compositeFilter.withAddedFilters(Collections.singletonList(fieldFilter));
        }
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        for (Filter subfilter : compositeFilter.getFilters()) {
            newFilters.add(LogicUtils.applyDistribution((Filter)fieldFilter, subfilter));
        }
        return new CompositeFilter(newFilters, StructuredQuery.CompositeFilter.Operator.OPERATOR_UNSPECIFIED);
    }

    private static Filter applyDistribution(CompositeFilter lhs, CompositeFilter rhs) {
        Assert.hardAssert(!lhs.getFilters().isEmpty() && !rhs.getFilters().isEmpty(), "Found an empty composite filter", new Object[0]);
        if (lhs.isConjunction() && rhs.isConjunction()) {
            return lhs.withAddedFilters(rhs.getFilters());
        }
        CompositeFilter disjunctionSide = lhs.isDisjunction() ? lhs : rhs;
        CompositeFilter otherSide = lhs.isDisjunction() ? rhs : lhs;
        ArrayList<Filter> results = new ArrayList<Filter>();
        for (Filter subfilter : disjunctionSide.getFilters()) {
            results.add(LogicUtils.applyDistribution(subfilter, (Filter)otherSide));
        }
        return new CompositeFilter(results, StructuredQuery.CompositeFilter.Operator.OPERATOR_UNSPECIFIED);
    }

    protected static Filter computeDistributedNormalForm(Filter filter) {
        LogicUtils.assertFieldFilterOrCompositeFilter(filter);
        if (filter instanceof FieldFilter) {
            return filter;
        }
        CompositeFilter compositeFilter = (CompositeFilter)filter;
        if (compositeFilter.getFilters().size() == 1) {
            return LogicUtils.computeDistributedNormalForm(filter.getFilters().get(0));
        }
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (Filter subfilter : compositeFilter.getFilters()) {
            result.add(LogicUtils.computeDistributedNormalForm(subfilter));
        }
        Filter newFilter = new CompositeFilter(result, compositeFilter.getOperator());
        if (LogicUtils.isDisjunctiveNormalForm(newFilter = LogicUtils.applyAssociation(newFilter))) {
            return newFilter;
        }
        Assert.hardAssert(newFilter instanceof CompositeFilter, "field filters are already in DNF form.", new Object[0]);
        Filter newCompositeFilter = newFilter;
        Assert.hardAssert(((CompositeFilter)newCompositeFilter).isConjunction(), "Disjunction of filters all of which are already in DNF form is itself in DNF form.", new Object[0]);
        Assert.hardAssert(((CompositeFilter)newCompositeFilter).getFilters().size() > 1, "Single-filter composite filters are already in DNF form.", new Object[0]);
        Filter runningResult = ((CompositeFilter)newCompositeFilter).getFilters().get(0);
        for (int i = 1; i < ((CompositeFilter)newCompositeFilter).getFilters().size(); ++i) {
            runningResult = LogicUtils.applyDistribution(runningResult, ((CompositeFilter)newCompositeFilter).getFilters().get(i));
        }
        return runningResult;
    }

    public static List<Filter> getDnfTerms(CompositeFilter filter) {
        if (filter.getFilters().isEmpty()) {
            return Collections.emptyList();
        }
        Filter result = LogicUtils.computeDistributedNormalForm(filter);
        Assert.hardAssert(LogicUtils.isDisjunctiveNormalForm(result), "computeDistributedNormalForm did not result in disjunctive normal form", new Object[0]);
        if (LogicUtils.isSingleFieldFilter(result) || LogicUtils.isFlatConjunction(result)) {
            return Collections.singletonList(result);
        }
        return result.getFilters();
    }
}

