/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.atomic.AtomicReference;

class FirebaseContextProvider
implements ContextProvider {
    private final String TAG = "FirebaseContextProvider";
    private final Provider<InternalAuthProvider> tokenProvider;
    private final Provider<FirebaseInstanceIdInternal> instanceId;
    private final AtomicReference<InternalAppCheckTokenProvider> appCheckRef = new AtomicReference();

    FirebaseContextProvider(Provider<InternalAuthProvider> tokenProvider, Provider<FirebaseInstanceIdInternal> instanceId, Deferred<InternalAppCheckTokenProvider> appCheckDeferred) {
        this.tokenProvider = tokenProvider;
        this.instanceId = instanceId;
        appCheckDeferred.whenAvailable(p -> {
            InternalAppCheckTokenProvider appCheck = (InternalAppCheckTokenProvider)p.get();
            this.appCheckRef.set(appCheck);
            appCheck.addAppCheckTokenListener(unused -> {});
        });
    }

    @Override
    public Task<HttpsCallableContext> getContext() {
        Task<String> authToken = this.getAuthToken();
        Task<String> appCheckToken = this.getAppCheckToken();
        return Tasks.whenAll(authToken, appCheckToken).onSuccessTask(v -> Tasks.forResult(new HttpsCallableContext((String)authToken.getResult(), this.instanceId.get().getToken(), (String)appCheckToken.getResult())));
    }

    private Task<String> getAuthToken() {
        InternalAuthProvider auth = this.tokenProvider.get();
        if (auth == null) {
            return Tasks.forResult(null);
        }
        return auth.getAccessToken(false).continueWith(task -> {
            String authToken = null;
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                if (!(exception instanceof FirebaseNoSignedInUserException)) {
                    throw exception;
                }
            } else {
                authToken = ((GetTokenResult)task.getResult()).getToken();
            }
            return authToken;
        });
    }

    private Task<String> getAppCheckToken() {
        InternalAppCheckTokenProvider appCheck = this.appCheckRef.get();
        if (appCheck == null) {
            return Tasks.forResult(null);
        }
        return appCheck.getToken(false).onSuccessTask(result -> {
            if (result.getError() != null) {
                Log.w("FirebaseContextProvider", "Error getting App Check token. Error: " + result.getError());
                return Tasks.forResult(null);
            }
            return Tasks.forResult(result.getToken());
        });
    }
}

