/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzar;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzv;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

final class zzao {
    private static int zza = 0;
    private static PendingIntent zzb;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzc = new SimpleArrayMap();
    private final Context zzd;
    private final zzai zze;
    private Messenger zzf;
    private Messenger zzg;
    private zzf zzh;

    public zzao(Context context, zzai zzai2) {
        this.zzd = context;
        this.zze = zzai2;
        this.zzf = new Messenger(new zzar(this, Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zza(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(new zzf.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zzf) {
                    this.zzh = (zzf)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzg = (Messenger)((Object)parcelable);
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzao zzao2 = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (!Log.isLoggable("FirebaseInstanceId", 3)) return;
                String string2 = String.valueOf(string);
                Log.d("FirebaseInstanceId", string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: "));
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                Intent intent3 = intent2;
                zzao zzao3 = zzao2;
                String string4 = intent3.getStringExtra("error");
                if (string4 == null) {
                    String string5 = String.valueOf(intent3.getExtras());
                    Log.w("FirebaseInstanceId", new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                    return;
                }
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    String string6 = String.valueOf(string4);
                    Log.d("FirebaseInstanceId", string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error "));
                }
                if (string4.startsWith("|")) {
                    String[] stringArray = string4.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string7 = String.valueOf(string4);
                        Log.w("FirebaseInstanceId", string7.length() != 0 ? "Unexpected structured response ".concat(string7) : new String("Unexpected structured response "));
                        return;
                    }
                    String string8 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                    zzao3.zza(string8, intent3.putExtra("error", string4).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = zzao3.zzc;
                synchronized (simpleArrayMap) {
                    int n = 0;
                    while (n < zzao3.zzc.size()) {
                        zzao3.zza((String)zzao3.zzc.keyAt(n), intent3.getExtras());
                        ++n;
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (matcher.matches()) {
                String string9 = matcher.group(1);
                String string10 = matcher.group(2);
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string10);
                zzao2.zza(string9, bundle);
                return;
            }
            if (!Log.isLoggable("FirebaseInstanceId", 3)) return;
            String string11 = String.valueOf(string3);
            Log.d("FirebaseInstanceId", string11.length() != 0 ? "Unexpected response string: ".concat(string11) : new String("Unexpected response string: "));
            return;
        }
        Log.w("FirebaseInstanceId", "Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzc.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w("FirebaseInstanceId", string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for "));
                return;
            }
            taskCompletionSource.setResult(bundle);
            return;
        }
    }

    final Bundle zza(Bundle bundle) throws IOException {
        if (this.zze.zzd() >= 12000000) {
            Task<Bundle> task = zzv.zza(this.zzd).zzb(1, bundle);
            try {
                return Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    String string = String.valueOf(exception);
                    Log.d("FirebaseInstanceId", new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzag && ((zzag)exception.getCause()).zza() == 4) {
                    return this.zzb(bundle);
                }
                return null;
            }
        }
        return this.zzb(bundle);
    }

    private final Bundle zzb(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzc(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzc(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zza() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzc(Bundle bundle) throws IOException {
        Object object;
        TaskCompletionSource taskCompletionSource;
        String string;
        block26: {
            zzao zzao2;
            Intent intent;
            block27: {
                Object object2;
                string = zzao.zza();
                taskCompletionSource = new TaskCompletionSource();
                object = this.zzc;
                synchronized (object) {
                    this.zzc.put((Object)string, taskCompletionSource);
                }
                String string2 = string;
                Bundle bundle2 = bundle;
                zzao zzao3 = this;
                if (zzao3.zze.zza() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzao3.zze.zza() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle2);
                zzao.zza(zzao3.zzd, intent2);
                String string3 = string2;
                intent = intent2;
                zzao2 = zzao3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string3).length()).append("|ID|").append(string3).append("|").toString());
                if (Log.isLoggable("FirebaseInstanceId", 3)) {
                    object2 = String.valueOf(intent.getExtras());
                    Log.d("FirebaseInstanceId", new StringBuilder(8 + String.valueOf(object2).length()).append("Sending ").append((String)object2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)((Object)zzao2.zzf));
                if (zzao2.zzg != null || zzao2.zzh != null) {
                    object2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzao2.zzg != null) {
                            zzao2.zzg.send((Message)object2);
                        } else {
                            zzao2.zzh.zza((Message)object2);
                        }
                        break block26;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable("FirebaseInstanceId", 3)) break block27;
                        Log.d("FirebaseInstanceId", "Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzao2.zze.zza() == 2) {
                zzao2.zzd.sendBroadcast(intent);
            } else {
                zzao2.zzd.startService(intent);
            }
        }
        try {
            object = (Bundle)Tasks.await(taskCompletionSource.getTask(), 30000L, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w("FirebaseInstanceId", "No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzc;
            synchronized (simpleArrayMap) {
                this.zzc.remove((Object)string);
            }
        }
    }

    static /* synthetic */ void zza(zzao zzao2, Message message) {
        zzao2.zza(message);
    }
}

