/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroid/net/Uri;", "", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "host", "", "kotlin.jvm.PlatformType", "getHost", "()Ljava/lang/String;", "port", "", "getPort", "()I", "scheme", "getScheme", "getQueryParameter", "key", "getQueryParameterNames", "", "Companion", "firebase-java-sdk"})
public final class Uri {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI uri;

    public Uri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
    }

    public final String getScheme() {
        return this.uri.getScheme();
    }

    public final int getPort() {
        return this.uri.getPort();
    }

    public final String getHost() {
        return this.uri.getHost();
    }

    @NotNull
    public final Set<String> getQueryParameterNames() {
        int end;
        String string = this.uri.getQuery();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String query = string;
        Set names = new LinkedHashSet();
        int start = 0;
        do {
            String name;
            int next;
            end = (next = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) == -1 ? query.length() : next;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            Intrinsics.checkNotNullExpressionValue((Object)query.substring(start, separator), (String)"substring(...)");
            names.add(name);
        } while ((start = end + 1) < query.length());
        Set<String> set = Collections.unmodifiableSet(names);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    @Nullable
    public final String getQueryParameter(@Nullable String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String string = this.uri.getQuery();
        if (string == null) {
            return null;
        }
        String query = string;
        int length = query.length();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : length;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == key.length() && StringsKt.regionMatches$default((String)query, (int)start, (String)key, (int)0, (int)key.length(), (boolean)false, (int)16, null)) {
                if (separator == end) {
                    return "";
                }
                String string2 = query.substring(separator + 1, end);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return string2;
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final Uri parse(@NotNull String uriString) {
        return Companion.parse(uriString);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroid/net/Uri$Companion;", "", "()V", "parse", "Landroid/net/Uri;", "uriString", "", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Uri parse(@NotNull String uriString) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            URI uRI = URI.create(uriString);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            return new Uri(uRI);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

