/*
 * Decompiled with CFR 0.152.
 */
package androidx.slidingpanelayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SlidingPaneLayout
extends ViewGroup {
    private static final String TAG = "SlidingPaneLayout";
    private static final int DEFAULT_OVERHANG_SIZE = 32;
    private static final int DEFAULT_FADE_COLOR = -858993460;
    private int mSliderFadeColor = -858993460;
    private static final int MIN_FLING_VELOCITY = 400;
    private int mCoveredFadeColor;
    private Drawable mShadowDrawableLeft;
    private Drawable mShadowDrawableRight;
    private final int mOverhangSize;
    private boolean mCanSlide;
    View mSlideableView;
    float mSlideOffset;
    private float mParallaxOffset;
    int mSlideRange;
    boolean mIsUnableToDrag;
    private int mParallaxBy;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private PanelSlideListener mPanelSlideListener;
    final ViewDragHelper mDragHelper;
    boolean mPreservedOpenState;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();
    final ArrayList<DisableLayerRunnable> mPostedRunnables = new ArrayList();
    private Method mGetDisplayList;
    private Field mRecreateDisplayList;
    private boolean mDisplayListReflectionLoaded;

    public SlidingPaneLayout(@NonNull Context context) {
        this(context, null);
    }

    public SlidingPaneLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingPaneLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = context.getResources().getDisplayMetrics().density;
        this.mOverhangSize = (int)(32.0f * density + 0.5f);
        this.setWillNotDraw(false);
        ViewCompat.setAccessibilityDelegate((View)((Object)this), new AccessibilityDelegate());
        ViewCompat.setImportantForAccessibility((View)((Object)this), 1);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new DragHelperCallback());
        this.mDragHelper.setMinVelocity(400.0f * density);
    }

    public void setParallaxDistance(@Px int parallaxBy) {
        this.mParallaxBy = parallaxBy;
        this.requestLayout();
    }

    @Px
    public int getParallaxDistance() {
        return this.mParallaxBy;
    }

    public void setSliderFadeColor(@ColorInt int color) {
        this.mSliderFadeColor = color;
    }

    @ColorInt
    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    public void setCoveredFadeColor(@ColorInt int color) {
        this.mCoveredFadeColor = color;
    }

    @ColorInt
    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setPanelSlideListener(@Nullable PanelSlideListener listener2) {
        this.mPanelSlideListener = listener2;
    }

    void dispatchOnPanelSlide(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(panel, this.mSlideOffset);
        }
    }

    void dispatchOnPanelOpened(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelClosed(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void updateObscuredViewsVisibility(View panel) {
        View child;
        int bottom;
        int top;
        int right;
        int left;
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        int startBound = isLayoutRtl ? this.getWidth() - this.getPaddingRight() : this.getPaddingLeft();
        int endBound = isLayoutRtl ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight();
        int topBound = this.getPaddingTop();
        int bottomBound = this.getHeight() - this.getPaddingBottom();
        if (panel != null && SlidingPaneLayout.viewIsOpaque(panel)) {
            left = panel.getLeft();
            right = panel.getRight();
            top = panel.getTop();
            bottom = panel.getBottom();
        } else {
            bottom = 0;
            top = 0;
            right = 0;
            left = 0;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount && (child = this.getChildAt(i)) != panel; ++i) {
            if (child.getVisibility() == 8) continue;
            int clampedChildLeft = Math.max(isLayoutRtl ? endBound : startBound, child.getLeft());
            int clampedChildTop = Math.max(topBound, child.getTop());
            int clampedChildRight = Math.min(isLayoutRtl ? startBound : endBound, child.getRight());
            int clampedChildBottom = Math.min(bottomBound, child.getBottom());
            int vis = clampedChildLeft >= left && clampedChildTop >= top && clampedChildRight <= right && clampedChildBottom <= bottom ? 4 : 0;
            child.setVisibility(vis);
        }
    }

    void setAllChildrenVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 4) continue;
            child.setVisibility(0);
        }
    }

    private static boolean viewIsOpaque(View v) {
        if (v.isOpaque()) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return false;
        }
        Drawable bg = v.getBackground();
        if (bg != null) {
            return bg.getOpacity() == -1;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int count = this.mPostedRunnables.size();
        for (int i = 0; i < count; ++i) {
            DisableLayerRunnable dlr = this.mPostedRunnables.get(i);
            dlr.run();
        }
        this.mPostedRunnables.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthAvailable;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            if (!this.isInEditMode()) throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
            if (widthMode == Integer.MIN_VALUE) {
                widthMode = 0x40000000;
            } else if (widthMode == 0) {
                widthMode = 0x40000000;
                widthSize = 300;
            }
        } else if (heightMode == 0) {
            if (!this.isInEditMode()) throw new IllegalStateException("Height must not be UNSPECIFIED");
            if (heightMode == 0) {
                heightMode = Integer.MIN_VALUE;
                heightSize = 300;
            }
        }
        int layoutHeight = 0;
        int maxLayoutHeight = 0;
        switch (heightMode) {
            case 0x40000000: {
                layoutHeight = maxLayoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
                break;
            }
            case -2147483648: {
                maxLayoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
            }
        }
        float weightSum = 0.0f;
        boolean canSlide = false;
        int widthRemaining = widthAvailable = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        int childCount = this.getChildCount();
        if (childCount > 2) {
            Log.e(TAG, "onMeasure: More than two child views are not supported.");
        }
        this.mSlideableView = null;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) {
                lp.dimWhenOffset = false;
                continue;
            }
            if (lp.weight > 0.0f) {
                weightSum += lp.weight;
                if (lp.width == 0) continue;
            }
            int horizontalMargin = lp.leftMargin + lp.rightMargin;
            int childWidthSpec = lp.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)(widthAvailable - horizontalMargin), (int)Integer.MIN_VALUE) : (lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(widthAvailable - horizontalMargin), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000));
            int childHeightSpec = lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
            child.measure(childWidthSpec, childHeightSpec);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (heightMode == Integer.MIN_VALUE && childHeight > layoutHeight) {
                layoutHeight = Math.min(childHeight, maxLayoutHeight);
            }
            lp.slideable = (widthRemaining -= childWidth) < 0;
            canSlide |= lp.slideable;
            if (!lp.slideable) continue;
            this.mSlideableView = child;
        }
        if (canSlide || weightSum > 0.0f) {
            int fixedPanelWidthLimit = widthAvailable - this.mOverhangSize;
            for (int i = 0; i < childCount; ++i) {
                int childWidthSpec;
                int childHeightSpec;
                int measuredWidth;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (child.getVisibility() == 8) continue;
                boolean skippedFirstPass = lp.width == 0 && lp.weight > 0.0f;
                int n = measuredWidth = skippedFirstPass ? 0 : child.getMeasuredWidth();
                if (canSlide && child != this.mSlideableView) {
                    if (lp.width >= 0 || measuredWidth <= fixedPanelWidthLimit && !(lp.weight > 0.0f)) continue;
                    childHeightSpec = skippedFirstPass ? (lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000);
                    int childWidthSpec2 = View.MeasureSpec.makeMeasureSpec((int)fixedPanelWidthLimit, (int)0x40000000);
                    child.measure(childWidthSpec2, childHeightSpec);
                    continue;
                }
                if (!(lp.weight > 0.0f)) continue;
                childHeightSpec = lp.width == 0 ? (lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)maxLayoutHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000))) : View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000);
                if (canSlide) {
                    int horizontalMargin = lp.leftMargin + lp.rightMargin;
                    int newWidth = widthAvailable - horizontalMargin;
                    childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                    if (measuredWidth == newWidth) continue;
                    child.measure(childWidthSpec, childHeightSpec);
                    continue;
                }
                int widthToDistribute = Math.max(0, widthRemaining);
                int addedWidth = (int)(lp.weight * (float)widthToDistribute / weightSum);
                childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(measuredWidth + addedWidth), (int)0x40000000);
                child.measure(childWidthSpec, childHeightSpec);
            }
        }
        int measuredWidth = widthSize;
        int measuredHeight = layoutHeight + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        this.mCanSlide = canSlide;
        if (this.mDragHelper.getViewDragState() == 0 || canSlide) return;
        this.mDragHelper.abort();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int i;
        int xStart;
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        if (isLayoutRtl) {
            this.mDragHelper.setEdgeTrackingEnabled(2);
        } else {
            this.mDragHelper.setEdgeTrackingEnabled(1);
        }
        int width = r - l;
        int paddingStart = isLayoutRtl ? this.getPaddingRight() : this.getPaddingLeft();
        int paddingEnd = isLayoutRtl ? this.getPaddingLeft() : this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int childCount = this.getChildCount();
        int nextXStart = xStart = paddingStart;
        if (this.mFirstLayout) {
            this.mSlideOffset = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
        }
        for (i = 0; i < childCount; ++i) {
            int childLeft;
            int childRight;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int offset = 0;
            if (lp.slideable) {
                int range;
                int margin = lp.leftMargin + lp.rightMargin;
                this.mSlideRange = range = Math.min(nextXStart, width - paddingEnd - this.mOverhangSize) - xStart - margin;
                int lpMargin = isLayoutRtl ? lp.rightMargin : lp.leftMargin;
                lp.dimWhenOffset = xStart + lpMargin + range + childWidth / 2 > width - paddingEnd;
                int pos = (int)((float)range * this.mSlideOffset);
                xStart += pos + lpMargin;
                this.mSlideOffset = (float)pos / (float)this.mSlideRange;
            } else if (this.mCanSlide && this.mParallaxBy != 0) {
                offset = (int)((1.0f - this.mSlideOffset) * (float)this.mParallaxBy);
                xStart = nextXStart;
            } else {
                xStart = nextXStart;
            }
            if (isLayoutRtl) {
                childRight = width - xStart + offset;
                childLeft = childRight - childWidth;
            } else {
                childLeft = xStart - offset;
                childRight = childLeft + childWidth;
            }
            int childTop = paddingTop;
            int childBottom = childTop + child.getMeasuredHeight();
            child.layout(childLeft, paddingTop, childRight, childBottom);
            nextXStart += child.getWidth();
        }
        if (this.mFirstLayout) {
            if (this.mCanSlide) {
                if (this.mParallaxBy != 0) {
                    this.parallaxOtherViews(this.mSlideOffset);
                }
                if (((LayoutParams)this.mSlideableView.getLayoutParams()).dimWhenOffset) {
                    this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
                }
            } else {
                for (i = 0; i < childCount; ++i) {
                    this.dimChildView(this.getChildAt(i), 0.0f, this.mSliderFadeColor);
                }
            }
            this.updateObscuredViewsVisibility(this.mSlideableView);
        }
        this.mFirstLayout = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.mFirstLayout = true;
        }
    }

    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            this.mPreservedOpenState = child == this.mSlideableView;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        View secondChild;
        int action = ev.getActionMasked();
        if (!this.mCanSlide && action == 0 && this.getChildCount() > 1 && (secondChild = this.getChildAt(1)) != null) {
            boolean bl = this.mPreservedOpenState = !this.mDragHelper.isViewUnder(secondChild, (int)ev.getX(), (int)ev.getY());
        }
        if (!this.mCanSlide || this.mIsUnableToDrag && action != 0) {
            this.mDragHelper.cancel();
            return super.onInterceptTouchEvent(ev);
        }
        if (action == 3 || action == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        boolean interceptTap = false;
        switch (action) {
            case 0: {
                this.mIsUnableToDrag = false;
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y) || !this.isDimmed(this.mSlideableView)) break;
                interceptTap = true;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float adx = Math.abs(x - this.mInitialMotionX);
                float ady = Math.abs(y - this.mInitialMotionY);
                int slop = this.mDragHelper.getTouchSlop();
                if (!(adx > (float)slop) || !(ady > adx)) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
        }
        boolean interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        return interceptForDrag || interceptTap;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mCanSlide) {
            return super.onTouchEvent(ev);
        }
        this.mDragHelper.processTouchEvent(ev);
        boolean wantTouchEvents = true;
        switch (ev.getActionMasked()) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                break;
            }
            case 1: {
                int slop;
                float y;
                float dy;
                float x;
                float dx;
                if (!this.isDimmed(this.mSlideableView) || !((dx = (x = ev.getX()) - this.mInitialMotionX) * dx + (dy = (y = ev.getY()) - this.mInitialMotionY) * dy < (float)((slop = this.mDragHelper.getTouchSlop()) * slop)) || !this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y)) break;
                this.closePane(this.mSlideableView, 0);
                break;
            }
        }
        return wantTouchEvents;
    }

    private boolean closePane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(0.0f, initialVelocity)) {
            this.mPreservedOpenState = false;
            return true;
        }
        return false;
    }

    private boolean openPane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(1.0f, initialVelocity)) {
            this.mPreservedOpenState = true;
            return true;
        }
        return false;
    }

    @Deprecated
    public void smoothSlideOpen() {
        this.openPane();
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    @Deprecated
    public void smoothSlideClosed() {
        this.closePane();
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    public boolean isOpen() {
        return !this.mCanSlide || this.mSlideOffset == 1.0f;
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    void onPanelDragged(int newLeft) {
        if (this.mSlideableView == null) {
            this.mSlideOffset = 0.0f;
            return;
        }
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        LayoutParams lp = (LayoutParams)this.mSlideableView.getLayoutParams();
        int childWidth = this.mSlideableView.getWidth();
        int newStart = isLayoutRtl ? this.getWidth() - newLeft - childWidth : newLeft;
        int paddingStart = isLayoutRtl ? this.getPaddingRight() : this.getPaddingLeft();
        int lpMargin = isLayoutRtl ? lp.rightMargin : lp.leftMargin;
        int startBound = paddingStart + lpMargin;
        this.mSlideOffset = (float)(newStart - startBound) / (float)this.mSlideRange;
        if (this.mParallaxBy != 0) {
            this.parallaxOtherViews(this.mSlideOffset);
        }
        if (lp.dimWhenOffset) {
            this.dimChildView(this.mSlideableView, this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    private void dimChildView(View v, float mag, int fadeColor) {
        LayoutParams lp = (LayoutParams)v.getLayoutParams();
        if (mag > 0.0f && fadeColor != 0) {
            int baseAlpha = (fadeColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * mag);
            int color = imag << 24 | fadeColor & 0xFFFFFF;
            if (lp.dimPaint == null) {
                lp.dimPaint = new Paint();
            }
            lp.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_OVER));
            if (v.getLayerType() != 2) {
                v.setLayerType(2, lp.dimPaint);
            }
            this.invalidateChildRegion(v);
        } else if (v.getLayerType() != 0) {
            if (lp.dimPaint != null) {
                lp.dimPaint.setColorFilter(null);
            }
            DisableLayerRunnable dlr = new DisableLayerRunnable(v);
            this.mPostedRunnables.add(dlr);
            ViewCompat.postOnAnimation((View)((Object)this), dlr);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int save = canvas.save();
        if (this.mCanSlide && !lp.slideable && this.mSlideableView != null) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.isLayoutRtlSupport()) {
                this.mTmpRect.left = Math.max(this.mTmpRect.left, this.mSlideableView.getRight());
            } else {
                this.mTmpRect.right = Math.min(this.mTmpRect.right, this.mSlideableView.getLeft());
            }
            canvas.clipRect(this.mTmpRect);
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(save);
        return result;
    }

    void invalidateChildRegion(View v) {
        if (Build.VERSION.SDK_INT >= 17) {
            ViewCompat.setLayerPaint(v, ((LayoutParams)v.getLayoutParams()).dimPaint);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (!this.mDisplayListReflectionLoaded) {
                try {
                    this.mGetDisplayList = View.class.getDeclaredMethod("getDisplayList", null);
                }
                catch (NoSuchMethodException e) {
                    Log.e(TAG, "Couldn't fetch getDisplayList method; dimming won't work right.", e);
                }
                try {
                    this.mRecreateDisplayList = View.class.getDeclaredField("mRecreateDisplayList");
                    this.mRecreateDisplayList.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    Log.e(TAG, "Couldn't fetch mRecreateDisplayList field; dimming will be slow.", e);
                }
                this.mDisplayListReflectionLoaded = true;
            }
            if (this.mGetDisplayList == null || this.mRecreateDisplayList == null) {
                v.invalidate();
                return;
            }
            try {
                this.mRecreateDisplayList.setBoolean(v, true);
                this.mGetDisplayList.invoke((Object)v, (Object[])null);
            }
            catch (Exception e) {
                Log.e(TAG, "Error refreshing display list state", e);
            }
        }
        ViewCompat.postInvalidateOnAnimation((View)((Object)this), v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
    }

    boolean smoothSlideTo(float slideOffset, int velocity) {
        int x;
        if (!this.mCanSlide) {
            return false;
        }
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        LayoutParams lp = (LayoutParams)this.mSlideableView.getLayoutParams();
        if (isLayoutRtl) {
            int startBound = this.getPaddingRight() + lp.rightMargin;
            int childWidth = this.mSlideableView.getWidth();
            x = (int)((float)this.getWidth() - ((float)startBound + slideOffset * (float)this.mSlideRange + (float)childWidth));
        } else {
            int startBound = this.getPaddingLeft() + lp.leftMargin;
            x = (int)((float)startBound + slideOffset * (float)this.mSlideRange);
        }
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, x, this.mSlideableView.getTop())) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)((Object)this));
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            if (!this.mCanSlide) {
                this.mDragHelper.abort();
                return;
            }
            ViewCompat.postInvalidateOnAnimation((View)((Object)this));
        }
    }

    @Deprecated
    public void setShadowDrawable(Drawable d) {
        this.setShadowDrawableLeft(d);
    }

    public void setShadowDrawableLeft(@Nullable Drawable d) {
        this.mShadowDrawableLeft = d;
    }

    public void setShadowDrawableRight(@Nullable Drawable d) {
        this.mShadowDrawableRight = d;
    }

    @Deprecated
    public void setShadowResource(@DrawableRes int resId) {
        this.setShadowDrawable(this.getResources().getDrawable(resId));
    }

    public void setShadowResourceLeft(int resId) {
        this.setShadowDrawableLeft(ContextCompat.getDrawable(this.getContext(), resId));
    }

    public void setShadowResourceRight(int resId) {
        this.setShadowDrawableRight(ContextCompat.getDrawable(this.getContext(), resId));
    }

    public void draw(Canvas c) {
        int right;
        int left;
        View shadowView;
        super.draw(c);
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        Drawable shadowDrawable = isLayoutRtl ? this.mShadowDrawableRight : this.mShadowDrawableLeft;
        View view = shadowView = this.getChildCount() > 1 ? this.getChildAt(1) : null;
        if (shadowView == null || shadowDrawable == null) {
            return;
        }
        int top = shadowView.getTop();
        int bottom = shadowView.getBottom();
        int shadowWidth = shadowDrawable.getIntrinsicWidth();
        if (this.isLayoutRtlSupport()) {
            left = shadowView.getRight();
            right = left + shadowWidth;
        } else {
            right = shadowView.getLeft();
            left = right - shadowWidth;
        }
        shadowDrawable.setBounds(left, top, right, bottom);
        shadowDrawable.draw(c);
    }

    private void parallaxOtherViews(float slideOffset) {
        boolean isLayoutRtl = this.isLayoutRtlSupport();
        LayoutParams slideLp = (LayoutParams)this.mSlideableView.getLayoutParams();
        boolean dimViews = slideLp.dimWhenOffset && (isLayoutRtl ? slideLp.rightMargin : slideLp.leftMargin) <= 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (v == this.mSlideableView) continue;
            int oldOffset = (int)((1.0f - this.mParallaxOffset) * (float)this.mParallaxBy);
            this.mParallaxOffset = slideOffset;
            int newOffset = (int)((1.0f - slideOffset) * (float)this.mParallaxBy);
            int dx = oldOffset - newOffset;
            v.offsetLeftAndRight(isLayoutRtl ? -dx : dx);
            if (!dimViews) continue;
            this.dimChildView(v, isLayoutRtl ? this.mParallaxOffset - 1.0f : 1.0f - this.mParallaxOffset, this.mCoveredFadeColor);
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally(this.isLayoutRtlSupport() ? dx : -dx);
    }

    boolean isDimmed(View child) {
        if (child == null) {
            return false;
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return this.mCanSlide && lp.dimWhenOffset && this.mSlideOffset > 0.0f;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isOpen = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = ss.isOpen;
    }

    boolean isLayoutRtlSupport() {
        return ViewCompat.getLayoutDirection((View)((Object)this)) == 1;
    }

    private class DisableLayerRunnable
    implements Runnable {
        final View mChildView;

        DisableLayerRunnable(View childView) {
            this.mChildView = childView;
        }

        @Override
        public void run() {
            if (this.mChildView.getParent() == SlidingPaneLayout.this) {
                this.mChildView.setLayerType(0, null);
                SlidingPaneLayout.this.invalidateChildRegion(this.mChildView);
            }
            SlidingPaneLayout.this.mPostedRunnables.remove(this);
        }
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            AccessibilityNodeInfoCompat superNode = AccessibilityNodeInfoCompat.obtain(info);
            super.onInitializeAccessibilityNodeInfo(host, superNode);
            this.copyNodeInfoNoChildren(info, superNode);
            superNode.recycle();
            info.setClassName(SlidingPaneLayout.class.getName());
            info.setSource(host);
            ViewParent parent = ViewCompat.getParentForAccessibility(host);
            if (parent instanceof View) {
                info.setParent((View)parent);
            }
            int childCount = SlidingPaneLayout.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = SlidingPaneLayout.this.getChildAt(i);
                if (this.filter(child) || child.getVisibility() != 0) continue;
                ViewCompat.setImportantForAccessibility(child, 1);
                info.addChild(child);
            }
        }

        @Override
        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)SlidingPaneLayout.class.getName());
        }

        @Override
        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            if (!this.filter(child)) {
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
            return false;
        }

        public boolean filter(View child) {
            return SlidingPaneLayout.this.isDimmed(child);
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat dest, AccessibilityNodeInfoCompat src) {
            Rect rect = this.mTmpRect;
            src.getBoundsInParent(rect);
            dest.setBoundsInParent(rect);
            src.getBoundsInScreen(rect);
            dest.setBoundsInScreen(rect);
            dest.setVisibleToUser(src.isVisibleToUser());
            dest.setPackageName(src.getPackageName());
            dest.setClassName(src.getClassName());
            dest.setContentDescription(src.getContentDescription());
            dest.setEnabled(src.isEnabled());
            dest.setClickable(src.isClickable());
            dest.setFocusable(src.isFocusable());
            dest.setFocused(src.isFocused());
            dest.setAccessibilityFocused(src.isAccessibilityFocused());
            dest.setSelected(src.isSelected());
            dest.setLongClickable(src.isLongClickable());
            dest.addAction(src.getActions());
            dest.setMovementGranularities(src.getMovementGranularities());
        }
    }

    static class SavedState
    extends AbsSavedState {
        boolean isOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, null);
            }

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.isOpen = in.readInt() != 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags2) {
            super.writeToParcel(out, flags2);
            out.writeInt(this.isOpen ? 1 : 0);
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        public float weight = 0.0f;
        boolean slideable;
        boolean dimWhenOffset;
        Paint dimPaint;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.weight = source.weight;
        }

        public LayoutParams(@NonNull Context c, @Nullable AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, ATTRS);
            this.weight = a.getFloat(0, 0.0f);
            a.recycle();
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        DragHelperCallback() {
        }

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidingPaneLayout.this.mIsUnableToDrag) {
                return false;
            }
            return ((LayoutParams)child.getLayoutParams()).slideable;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            if (SlidingPaneLayout.this.mDragHelper.getViewDragState() == 0) {
                if (SlidingPaneLayout.this.mSlideOffset == 0.0f) {
                    SlidingPaneLayout.this.updateObscuredViewsVisibility(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.dispatchOnPanelClosed(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.mPreservedOpenState = false;
                } else {
                    SlidingPaneLayout.this.dispatchOnPanelOpened(SlidingPaneLayout.this.mSlideableView);
                    SlidingPaneLayout.this.mPreservedOpenState = true;
                }
            }
        }

        @Override
        public void onViewCaptured(View capturedChild, int activePointerId) {
            SlidingPaneLayout.this.setAllChildrenVisible();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidingPaneLayout.this.onPanelDragged(left);
            SlidingPaneLayout.this.invalidate();
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int left;
            LayoutParams lp = (LayoutParams)releasedChild.getLayoutParams();
            if (SlidingPaneLayout.this.isLayoutRtlSupport()) {
                int startToRight = SlidingPaneLayout.this.getPaddingRight() + lp.rightMargin;
                if (xvel < 0.0f || xvel == 0.0f && SlidingPaneLayout.this.mSlideOffset > 0.5f) {
                    startToRight += SlidingPaneLayout.this.mSlideRange;
                }
                int childWidth = SlidingPaneLayout.this.mSlideableView.getWidth();
                left = SlidingPaneLayout.this.getWidth() - startToRight - childWidth;
            } else {
                left = SlidingPaneLayout.this.getPaddingLeft() + lp.leftMargin;
                if (xvel > 0.0f || xvel == 0.0f && SlidingPaneLayout.this.mSlideOffset > 0.5f) {
                    left += SlidingPaneLayout.this.mSlideRange;
                }
            }
            SlidingPaneLayout.this.mDragHelper.settleCapturedViewAt(left, releasedChild.getTop());
            SlidingPaneLayout.this.invalidate();
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return SlidingPaneLayout.this.mSlideRange;
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int newLeft;
            LayoutParams lp = (LayoutParams)SlidingPaneLayout.this.mSlideableView.getLayoutParams();
            if (SlidingPaneLayout.this.isLayoutRtlSupport()) {
                int startBound = SlidingPaneLayout.this.getWidth() - (SlidingPaneLayout.this.getPaddingRight() + lp.rightMargin + SlidingPaneLayout.this.mSlideableView.getWidth());
                int endBound = startBound - SlidingPaneLayout.this.mSlideRange;
                newLeft = Math.max(Math.min(left, startBound), endBound);
            } else {
                int startBound = SlidingPaneLayout.this.getPaddingLeft() + lp.leftMargin;
                int endBound = startBound + SlidingPaneLayout.this.mSlideRange;
                newLeft = Math.min(Math.max(left, startBound), endBound);
            }
            return newLeft;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop();
        }

        @Override
        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            SlidingPaneLayout.this.mDragHelper.captureChildView(SlidingPaneLayout.this.mSlideableView, pointerId);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelSlide(View panel, float slideOffset) {
        }

        @Override
        public void onPanelOpened(View panel) {
        }

        @Override
        public void onPanelClosed(View panel) {
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(@NonNull View var1, float var2);

        public void onPanelOpened(@NonNull View var1);

        public void onPanelClosed(@NonNull View var1);
    }
}

