/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zacb;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import java.util.concurrent.Executor;

@KeepForSdk
public final class ListenerHolder<L> {
    private final Executor zaa;
    @Nullable
    private volatile Object zab;
    @Nullable
    private volatile ListenerKey zac;

    @Nullable
    @KeepForSdk
    public ListenerKey<L> getListenerKey() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L listener2, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        ListenerKey<void> listenerKey;
        HandlerExecutor handlerExecutor = new HandlerExecutor((Looper)((Object)listenerKey));
        this.zaa = handlerExecutor;
        this.zab = Preconditions.checkNotNull(var2_2, "Listener must not be null");
        this.zac = listenerKey = new ListenerKey<void>(var2_2, Preconditions.checkNotEmpty((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Executor executor, @NonNull L listener2, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        ListenerKey<void> listenerKey;
        this.zaa = (Executor)Preconditions.checkNotNull(listenerKey, "Executor must not be null");
        this.zab = Preconditions.checkNotNull(var2_2, "Listener must not be null");
        this.zac = listenerKey = new ListenerKey<void>(var2_2, Preconditions.checkNotEmpty((String)var3_3));
    }

    @KeepForSdk
    public void clear() {
        this.zab = null;
        this.zac = null;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void notifyListener(@NonNull Notifier<? super L> notifier) {
        void var1_1;
        Preconditions.checkNotNull(notifier, "Notifier must not be null");
        Executor executor = this.zaa;
        zacb zacb2 = new zacb(this, (Notifier)var1_1);
        executor.execute(zacb2);
    }

    @KeepForSdk
    public boolean hasListener() {
        return this.zab != null;
    }

    final void zaa(Notifier notifier) {
        Object object = ((ListenerHolder)object).zab;
        if (object == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(object);
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final Object zaa;
        private final String zab;

        @KeepForSdk
        public int hashCode() {
            return System.identityHashCode(this.zaa) * 31 + this.zab.hashCode();
        }

        @KeepForSdk
        @NonNull
        public String toIdString() {
            String string2 = ((ListenerKey)this_).zab;
            Object this_ = ((ListenerKey)this_).zaa;
            int n = System.identityHashCode(this_);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("@");
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        ListenerKey(L listener2, String listenerType) {
            void var2_2;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var2_2;
        }

        @KeepForSdk
        public boolean equals(@Nullable Object o) {
            ListenerKey listenerKey;
            if (this == listenerKey) {
                return true;
            }
            if (!(listenerKey instanceof ListenerKey)) {
                return false;
            }
            listenerKey = listenerKey;
            return this.zaa == listenerKey.zaa && this.zab.equals(listenerKey.zab);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(@NonNull L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

