/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;

@KeepForSdk
public final class GmsLogger {
    private final String zza;
    @Nullable
    private final String zzb;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public GmsLogger(@NonNull String logTag) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public GmsLogger(@NonNull String logTag, @Nullable String messagePrefix) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(var1_1, "log tag cannot be null");
        boolean bl = var1_1.length() <= 23;
        Object[] objectArray = new Object[]{var1_1, 23};
        Preconditions.checkArgument(bl, "tag \"%s\" is longer than the %d character maximum", objectArray);
        this.zza = var1_1;
        if (var2_2 != null && var2_2.length() > 0) {
            this.zzb = var2_2;
            return;
        }
        this.zzb = null;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void d(@NonNull String tag, @NonNull String message) {
        if (this.canLog(3)) {
            void var2_2;
            void var1_1;
            Log.d((String)var1_1, this.zza((String)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void d(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(3)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.d((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void e(@NonNull String tag, @NonNull String message) {
        if (this.canLog(6)) {
            void var2_2;
            void var1_1;
            Log.e((String)var1_1, this.zza((String)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void e(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(6)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.e((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @FormatMethod
    public void efmt(@NonNull String tag, @FormatString @NonNull String messageFormatString, Object ... messageParams) {
        if (this.canLog(6)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.e((String)var1_1, this.zzb((String)var2_2, (Object[])var3_3));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void i(@NonNull String tag, @NonNull String message) {
        if (this.canLog(4)) {
            void var2_2;
            void var1_1;
            Log.i((String)var1_1, this.zza((String)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void i(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(4)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.i((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    @KeepForSdk
    public void pii(@NonNull String string2, @NonNull String string3) {
    }

    @KeepForSdk
    public void pii(@NonNull String string2, @NonNull String string3, @NonNull Throwable throwable) {
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void v(@NonNull String tag, @NonNull String message) {
        if (this.canLog(2)) {
            void var2_2;
            void var1_1;
            Log.v((String)var1_1, this.zza((String)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void v(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(2)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.v((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void w(@NonNull String tag, @NonNull String message) {
        if (this.canLog(5)) {
            void var2_2;
            void var1_1;
            Log.w((String)var1_1, this.zza((String)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void w(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(5)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.w((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @FormatMethod
    public void wfmt(@NonNull String string2, @FormatString @NonNull String messageFormatString, Object ... messageParams) {
        if (this.canLog(5)) {
            void var3_3;
            void var2_2;
            Log.w(this.zza, this.zzb((String)var2_2, (Object[])var3_3));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void wtf(@NonNull String tag, @NonNull String message, @NonNull Throwable thr) {
        if (this.canLog(7)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.e((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            Log.wtf((String)var1_1, this.zza((String)var2_2), (Throwable)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean canLog(int level) {
        void var1_1;
        return Log.isLoggable(this.zza, (int)var1_1);
    }

    @KeepForSdk
    public boolean canLogPii() {
        return false;
    }

    private final String zza(String string2) {
        String string3 = ((GmsLogger)((Object)string3)).zzb;
        if (string3 == null) {
            return string2;
        }
        return string3.concat(string2);
    }

    @FormatMethod
    private final String zzb(String string2, Object ... objectArray) {
        string2 = String.format(string2, objectArray);
        String string3 = ((GmsLogger)((Object)string3)).zzb;
        if (string3 == null) {
            return string2;
        }
        return string3.concat(string2);
    }
}

