/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    final SharedPreferences store;
    final Context context;
    @GuardedBy(value="this")
    private final Map<String, Long> subtypeCreationTimes;

    public Store(Context context) {
        ArrayMap arrayMap;
        this.subtypeCreationTimes = arrayMap = new ArrayMap();
        this.context = context;
        this.store = context.getSharedPreferences("com.google.android.gms.appid", 0);
        this.checkForRestore("com.google.android.gms.appid-no-backup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForRestore(String object) {
        object = this.context;
        File file = new File((File)(object = ContextCompat.getNoBackupFilesDir((Context)object)), "com.google.android.gms.appid-no-backup");
        if (file.exists()) {
            return;
        }
        try {
            boolean bl = file.createNewFile();
            if (!bl || (bl = this.isEmpty())) return;
            Log.i("FirebaseInstanceId", "App restored, clearing state");
            this.deleteAll();
            return;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable("FirebaseInstanceId", 3)) {
                return;
            }
            String string2 = String.valueOf(iOException.getMessage());
            object = "Error creating file in no backup dir: ";
            string2 = string2.length() != 0 ? ((String)object).concat(string2) : new String((String)object);
            Log.d("FirebaseInstanceId", string2);
            return;
        }
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    private String createTokenKey(String string2, String string3, String string4) {
        String string5 = String.valueOf(string2);
        int n = string5.length();
        String string6 = String.valueOf(string3);
        int n2 = string6.length();
        String string7 = String.valueOf(string4);
        int n3 = string7.length();
        StringBuilder stringBuilder = new StringBuilder(n + 4 + n2 + n3);
        stringBuilder.append(string2);
        stringBuilder.append("|T|");
        stringBuilder.append(string3);
        stringBuilder.append("|");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    static String createSubtypeInfoKey(String string2, String string3) {
        string3 = String.valueOf(string2);
        int n = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + 6);
        stringBuilder.append(string2);
        stringBuilder.append("|S|cre");
        return stringBuilder.toString();
    }

    public synchronized void deleteAll() {
        this.subtypeCreationTimes.clear();
        this.store.edit().clear().commit();
    }

    public synchronized Token getToken(String string2, String string3, String string4) {
        return Token.parse(this.store.getString(this.createTokenKey(string2, string3, string4), null));
    }

    public synchronized void saveToken(String string2, String string3, String string4, String string5, String object) {
        if ((string5 = Token.encode(string5, (String)object, System.currentTimeMillis())) == null) {
            return;
        }
        object = this.store.edit();
        object.putString(this.createTokenKey(string2, string3, string4), string5);
        object.commit();
    }

    public synchronized void deleteToken(String string2, String string3, String string4) {
        string2 = ((Store)((Object)editor)).createTokenKey(string2, string3, string4);
        SharedPreferences.Editor editor = ((Store)((Object)editor)).store.edit();
        editor.remove(string2);
        editor.commit();
    }

    public synchronized long getCreationTime(String string2) {
        Long l = this.subtypeCreationTimes.get(string2);
        if (l != null) {
            return l;
        }
        return this.getCreationTimeFromSharedPreferences(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCreationTimeFromSharedPreferences(String string2) {
        String string3 = ((Store)((Object)string3)).store.getString(Store.createSubtypeInfoKey(string2, "cre"), null);
        if (string3 == null) return 0L;
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public synchronized long setCreationTime(String string2) {
        long l = this.writeCreationTimeToSharedPreferences(string2);
        this.subtypeCreationTimes.put(string2, l);
        return l;
    }

    private long writeCreationTimeToSharedPreferences(String string2) {
        long l = System.currentTimeMillis();
        String string3 = Store.createSubtypeInfoKey(string2, "cre");
        if (!((Store)((Object)editor)).store.contains(string3)) {
            SharedPreferences.Editor editor = ((Store)((Object)editor)).store.edit();
            editor.putString(Store.createSubtypeInfoKey(string2, "cre"), String.valueOf(l));
            editor.commit();
            return l;
        }
        return ((Store)((Object)editor)).getCreationTimeFromSharedPreferences(string2);
    }

    static class Token {
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        private Token(String string2, String string3, long l) {
            this.token = string2;
            this.appVersion = string3;
            this.timestamp = l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Token parse(String object) {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if (!((String)object).startsWith("{")) return new Token((String)object, null, 0L);
            try {
                JSONObject jSONObject = new JSONObject((String)object);
                return new Token(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
            }
            catch (JSONException jSONException) {
                String string2 = String.valueOf(jSONException);
                String string3 = String.valueOf(string2);
                int n = string3.length();
                StringBuilder stringBuilder = new StringBuilder(n + 23);
                stringBuilder.append("Failed to parse token: ");
                stringBuilder.append(string2);
                Log.w("FirebaseInstanceId", stringBuilder.toString());
                return null;
            }
        }

        static String encode(String string2, String string3, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", string2);
                jSONObject.put("appVersion", string3);
                jSONObject.put("timestamp", l);
                string2 = jSONObject.toString();
                return string2;
            }
            catch (JSONException jSONException) {
                String string4 = String.valueOf(jSONException);
                string3 = String.valueOf(string4);
                int n = string3.length();
                StringBuilder stringBuilder = new StringBuilder(n + 24);
                stringBuilder.append("Failed to encode token: ");
                stringBuilder.append(string4);
                Log.w("FirebaseInstanceId", stringBuilder.toString());
                return null;
            }
        }

        static String getTokenOrNull(@Nullable Token token) {
            if (token == null) {
                return null;
            }
            return token.token;
        }

        boolean needsRefresh(String string2) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !string2.equals(this.appVersion);
        }
    }
}

