/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.firebase.installations.local.AutoValue_PersistedInstallationEntry;
import com.google.firebase.installations.local.PersistedInstallation;

@AutoValue
public abstract class PersistedInstallationEntry {
    @NonNull
    public static PersistedInstallationEntry INSTANCE = PersistedInstallationEntry.builder().build();

    @Nullable
    public abstract String getFirebaseInstallationId();

    @NonNull
    public abstract PersistedInstallation.RegistrationStatus getRegistrationStatus();

    @Nullable
    public abstract String getAuthToken();

    @Nullable
    public abstract String getRefreshToken();

    public abstract long getExpiresInSecs();

    public abstract long getTokenCreationEpochInSecs();

    @Nullable
    public abstract String getFisError();

    public boolean isRegistered() {
        return this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.REGISTERED;
    }

    public boolean isErrored() {
        return this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.REGISTER_ERROR;
    }

    public boolean isUnregistered() {
        return this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.UNREGISTERED;
    }

    public boolean isNotGenerated() {
        return this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.NOT_GENERATED || this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION;
    }

    public boolean shouldAttemptMigration() {
        return this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION;
    }

    @NonNull
    public PersistedInstallationEntry withUnregisteredFid(@NonNull String fid) {
        return this.toBuilder().setFirebaseInstallationId(fid).setRegistrationStatus(PersistedInstallation.RegistrationStatus.UNREGISTERED).build();
    }

    @NonNull
    public PersistedInstallationEntry withRegisteredFid(@NonNull String fid, @NonNull String refreshToken2, long creationTime, @Nullable String authToken, long authTokenExpiration) {
        return this.toBuilder().setFirebaseInstallationId(fid).setRegistrationStatus(PersistedInstallation.RegistrationStatus.REGISTERED).setAuthToken(authToken).setRefreshToken(refreshToken2).setExpiresInSecs(authTokenExpiration).setTokenCreationEpochInSecs(creationTime).build();
    }

    @NonNull
    public PersistedInstallationEntry withFisError(@NonNull String message) {
        return this.toBuilder().setFisError(message).setRegistrationStatus(PersistedInstallation.RegistrationStatus.REGISTER_ERROR).build();
    }

    @NonNull
    public PersistedInstallationEntry withNoGeneratedFid() {
        return this.toBuilder().setRegistrationStatus(PersistedInstallation.RegistrationStatus.NOT_GENERATED).build();
    }

    @NonNull
    public PersistedInstallationEntry withAuthToken(@NonNull String authToken, long authTokenExpiration, long creationTime) {
        return this.toBuilder().setAuthToken(authToken).setExpiresInSecs(authTokenExpiration).setTokenCreationEpochInSecs(creationTime).build();
    }

    @NonNull
    public PersistedInstallationEntry withClearedAuthToken() {
        return this.toBuilder().setAuthToken(null).build();
    }

    @NonNull
    public abstract Builder toBuilder();

    @NonNull
    public static Builder builder() {
        return new AutoValue_PersistedInstallationEntry.Builder().setTokenCreationEpochInSecs(0L).setRegistrationStatus(PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION).setExpiresInSecs(0L);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setFirebaseInstallationId(@NonNull String var1);

        @NonNull
        public abstract Builder setRegistrationStatus(@NonNull PersistedInstallation.RegistrationStatus var1);

        @NonNull
        public abstract Builder setAuthToken(@Nullable String var1);

        @NonNull
        public abstract Builder setRefreshToken(@Nullable String var1);

        @NonNull
        public abstract Builder setExpiresInSecs(long var1);

        @NonNull
        public abstract Builder setTokenCreationEpochInSecs(long var1);

        @NonNull
        public abstract Builder setFisError(@Nullable String var1);

        @NonNull
        public abstract PersistedInstallationEntry build();
    }
}

