/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzaj;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public interface IGmsServiceBroker
extends IInterface {
    @KeepForSdk
    public void getService(@NonNull IGmsCallbacks var1, @Nullable GetServiceRequest var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGmsServiceBroker {
        @Override
        @CanIgnoreReturnValue
        @KeepForSdk
        @NonNull
        public IBinder asBinder() {
            return this;
        }

        public Stub() {
            this.attachInterface(this, "com.google.android.gms.common.internal.IGmsServiceBroker");
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean onTransact(int n, @NonNull Parcel parcel, @Nullable Parcel parcel2, int n2) throws RemoteException {
            Object object;
            if (n > 0xFFFFFF) {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            parcel.enforceInterface("com.google.android.gms.common.internal.IGmsServiceBroker");
            Object object2 = parcel.readStrongBinder();
            if (object2 == null) {
                object2 = null;
            } else {
                IInterface iInterface = object2.queryLocalInterface("com.google.android.gms.common.internal.IGmsCallbacks");
                if (iInterface instanceof IGmsCallbacks) {
                    object2 = (IGmsCallbacks)iInterface;
                } else {
                    iInterface = new zzaa((IBinder)object2);
                    object2 = iInterface;
                }
            }
            if (n == 46) {
                GetServiceRequest getServiceRequest = parcel.readInt() != 0 ? GetServiceRequest.CREATOR.createFromParcel(parcel) : null;
                object.getService((IGmsCallbacks)object2, getServiceRequest);
                Preconditions.checkNotNull(parcel2);
                parcel2.writeNoException();
                return true;
            }
            if (n == 47) {
                if (parcel.readInt() != 0) {
                    zzaj.CREATOR.createFromParcel(parcel);
                }
                object = new UnsupportedOperationException();
                throw object;
            }
            parcel.readInt();
            if (n != 4) {
                parcel.readString();
                switch (n) {
                    case 1: {
                        parcel.readString();
                        parcel.createStringArray();
                        parcel.readString();
                        if (parcel.readInt() == 0) break;
                        Bundle cfr_ignored_0 = (Bundle)Bundle.CREATOR.createFromParcel(parcel);
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 23: 
                    case 25: 
                    case 27: 
                    case 37: 
                    case 38: 
                    case 41: 
                    case 43: {
                        if (parcel.readInt() == 0) break;
                        Bundle cfr_ignored_1 = (Bundle)Bundle.CREATOR.createFromParcel(parcel);
                        break;
                    }
                    case 9: {
                        parcel.readString();
                        parcel.createStringArray();
                        parcel.readString();
                        parcel.readStrongBinder();
                        parcel.readString();
                        if (parcel.readInt() == 0) break;
                        Bundle cfr_ignored_2 = (Bundle)Bundle.CREATOR.createFromParcel(parcel);
                        break;
                    }
                    case 10: {
                        parcel.readString();
                        parcel.createStringArray();
                        break;
                    }
                    case 19: {
                        parcel.readStrongBinder();
                        if (parcel.readInt() == 0) break;
                        Bundle cfr_ignored_3 = (Bundle)Bundle.CREATOR.createFromParcel(parcel);
                        break;
                    }
                    case 20: 
                    case 30: {
                        parcel.createStringArray();
                        parcel.readString();
                        if (parcel.readInt() == 0) break;
                        Bundle cfr_ignored_4 = (Bundle)Bundle.CREATOR.createFromParcel(parcel);
                        break;
                    }
                    case 34: {
                        parcel.readString();
                        break;
                    }
                }
            }
            object = new UnsupportedOperationException();
            throw object;
        }
    }
}

