/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebasePlatform;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthKt;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserImpl;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 j2\u00020\u0001:\u0003ijkB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015H\u0016J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010.\u001a\u00020\u001bJ\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000-2\u0006\u0010.\u001a\u00020\u001bJ\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010.\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bJ%\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020<0-2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u001bJ\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020 H\u0002J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0-2\u0006\u0010=\u001a\u00020\u001bJ\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0-2\u0006\u0010D\u001a\u00020EH\u0016J\n\u0010F\u001a\u0004\u0018\u00010\u001bH\u0016J\u000e\u0010G\u001a\u00020E2\u0006\u0010H\u001a\u00020\u001bJN\u0010I\u001a\u00020)\"\u0004\b\u0000\u0010J2\u0006\u0010\"\u001a\u00020 2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\u001f2#\u0010L\u001a\u001f\u0012\u0013\u0012\u00110 \u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(\"\u0012\u0006\u0012\u0004\u0018\u0001HJ0MH\u0000\u00a2\u0006\u0002\bPJ\u000e\u0010Q\u001a\u00020)2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010R\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010R\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015H\u0016J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010=\u001a\u00020\u001b2\b\u0010T\u001a\u0004\u0018\u00010UJ\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010W\u001a\u00020UJ\u000e\u0010X\u001a\u00020Y2\u0006\u0010!\u001a\u00020\u001bJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020<0-J\u0014\u0010[\u001a\b\u0012\u0004\u0012\u00020<0-2\u0006\u0010\\\u001a\u00020]J\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020<0-2\u0006\u0010_\u001a\u00020\u001bJ\u001c\u0010`\u001a\b\u0012\u0004\u0012\u00020<0-2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u001bJ\u001c\u0010a\u001a\b\u0012\u0004\u0012\u00020<0-2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010H\u001a\u00020\u001bJ\u0006\u0010b\u001a\u00020)J\u0014\u0010c\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010\"\u001a\u00020\u000fJ\u0016\u0010d\u001a\u00020)2\u0006\u0010e\u001a\u00020\u001b2\u0006\u0010f\u001a\u00020gJ\u0014\u0010h\u001a\b\u0012\u0004\u0012\u00020\u001b0-2\u0006\u0010.\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 @BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b#\u0010$R\u0015\u0010%\u001a\u00020\u001b*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006l"}, d2={"Lcom/google/firebase/auth/FirebaseAuth;", "Lcom/google/firebase/auth/internal/InternalAuthProvider;", "app", "Lcom/google/firebase/FirebaseApp;", "(Lcom/google/firebase/FirebaseApp;)V", "getApp", "()Lcom/google/firebase/FirebaseApp;", "authStateListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "currentUser", "Lcom/google/firebase/auth/FirebaseUser;", "getCurrentUser", "()Lcom/google/firebase/auth/FirebaseUser;", "idTokenListeners", "Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "internalIdTokenListeners", "Lcom/google/firebase/auth/internal/IdTokenListener;", "json", "Lokhttp3/MediaType;", "getJson", "()Lokhttp3/MediaType;", "languageCode", "", "getLanguageCode", "()Ljava/lang/String;", "refreshSource", "Lcom/google/android/gms/tasks/TaskCompletionSource;", "Lcom/google/firebase/auth/FirebaseUserImpl;", "value", "user", "setUser", "(Lcom/google/firebase/auth/FirebaseUserImpl;)V", "key", "getKey", "(Lcom/google/firebase/FirebaseApp;)Ljava/lang/String;", "addAuthStateListener", "", "listener", "addIdTokenListener", "applyActionCode", "Lcom/google/android/gms/tasks/Task;", "code", "checkActionCode", "Lcom/google/firebase/auth/ActionCodeResult;", "confirmPasswordReset", "newPassword", "createAuthInvalidUserException", "Lcom/google/firebase/auth/FirebaseAuthInvalidUserException;", "action", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "createAuthInvalidUserException$firebase_java_sdk", "createUserWithEmailAndPassword", "Lcom/google/firebase/auth/AuthResult;", "email", "password", "enqueueRefreshTokenCall", "fetchSignInMethodsForEmail", "Lcom/google/firebase/auth/SignInMethodQueryResult;", "getAccessToken", "Lcom/google/firebase/auth/GetTokenResult;", "forceRefresh", "", "getUid", "isSignInWithEmailLink", "link", "refreshToken", "T", "source", "map", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "refreshToken$firebase_java_sdk", "removeAuthStateListener", "removeIdTokenListener", "sendPasswordResetEmail", "settings", "Lcom/google/firebase/auth/ActionCodeSettings;", "sendSignInLinkToEmail", "actionCodeSettings", "setLanguageCode", "", "signInAnonymously", "signInWithCredential", "authCredential", "Lcom/google/firebase/auth/AuthCredential;", "signInWithCustomToken", "customToken", "signInWithEmailAndPassword", "signInWithEmailLink", "signOut", "updateCurrentUser", "useEmulator", "host", "port", "", "verifyPasswordResetCode", "AuthStateListener", "Companion", "IdTokenListener", "firebase-java-sdk"})
@SourceDebugExtension(value={"SMAP\nFirebaseAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseAuth.kt\ncom/google/firebase/auth/FirebaseAuth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,444:1\n1#2:445\n*E\n"})
public final class FirebaseAuth
implements InternalAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp app;
    @Nullable
    private final MediaType json;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener> internalIdTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<IdTokenListener> idTokenListeners;
    @NotNull
    private final CopyOnWriteArrayList<AuthStateListener> authStateListeners;
    @Nullable
    private FirebaseUserImpl user;
    @NotNull
    private TaskCompletionSource<FirebaseUserImpl> refreshSource;

    /*
     * WARNING - void declaration
     */
    public FirebaseAuth(@NotNull FirebaseApp app) {
        void $this$refreshSource_u24lambda_u245;
        TaskCompletionSource $this$user_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.app = app;
        this.json = MediaType.parse((String)"application/json; charset=utf-8");
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"build(...)");
        this.client = okHttpClient;
        this.internalIdTokenListeners = new CopyOnWriteArrayList();
        this.idTokenListeners = new CopyOnWriteArrayList();
        this.authStateListeners = new CopyOnWriteArrayList();
        TaskCompletionSource taskCompletionSource = FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk();
        FirebaseAuth firebaseAuth = this;
        try {
            FirebaseUserImpl firebaseUserImpl;
            $this$user_u24lambda_u242 = taskCompletionSource;
            boolean bl = false;
            String string = ((FirebasePlatform)((Object)$this$user_u24lambda_u242)).retrieve(this.getKey(this.app));
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                firebaseUserImpl = new FirebaseUserImpl(this.app, JsonElementKt.getJsonObject((JsonElement)FirebaseAuthKt.getJsonParser().parseToJsonElement(it)), false, 4, null);
            } else {
                firebaseUserImpl = null;
            }
            $this$user_u24lambda_u242 = Result.constructor-impl(firebaseUserImpl);
        }
        catch (Throwable bl) {
            $this$user_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        taskCompletionSource = $this$user_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)taskCompletionSource);
        if (throwable != null) {
            void it;
            TaskCompletionSource bl = $this$user_u24lambda_u242 = throwable;
            firebaseAuth = firebaseAuth2;
            boolean bl3 = false;
            it.printStackTrace();
            firebaseAuth2 = firebaseAuth;
        }
        firebaseAuth2.user = (FirebaseUserImpl)((Object)(Result.isFailure-impl((Object)taskCompletionSource) ? null : taskCompletionSource));
        $this$user_u24lambda_u242 = taskCompletionSource = new TaskCompletionSource();
        firebaseAuth = this;
        boolean bl = false;
        $this$refreshSource_u24lambda_u245.setException(new Exception());
        firebaseAuth.refreshSource = taskCompletionSource;
    }

    @NotNull
    public final FirebaseApp getApp() {
        return this.app;
    }

    @Nullable
    public final MediaType getJson() {
        return this.json;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @Nullable
    public final FirebaseUser getCurrentUser() {
        return this.user;
    }

    @NotNull
    public final String getKey(@NotNull FirebaseApp $this$key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        String it = string = "[" + $this$key.getName() + "]";
        boolean bl = false;
        Object object = !$this$key.isDefaultApp() ? string : null;
        if (object == null) {
            object = "";
        }
        return "com.google.firebase.auth.FIREBASE_USER" + (String)object;
    }

    private final void setUser(FirebaseUserImpl value) {
        if (!Intrinsics.areEqual((Object)this.user, (Object)value)) {
            FirebaseUserImpl prev = this.user;
            this.user = value;
            if (value == null) {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().clear(this.getKey(this.app));
            } else {
                FirebasePlatform.Companion.getFirebasePlatform$firebase_java_sdk().store(this.getKey(this.app), FirebaseAuthKt.getJsonParser().encodeToString((SerializationStrategy)FirebaseUserImpl.Companion.serializer(), (Object)value));
            }
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(prev, value, this, null){
                int label;
                final /* synthetic */ FirebaseUserImpl $prev;
                final /* synthetic */ FirebaseUserImpl $value;
                final /* synthetic */ FirebaseAuth this$0;
                {
                    this.$prev = $prev;
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            FirebaseUserImpl firebaseUserImpl = this.$prev;
                            FirebaseUserImpl firebaseUserImpl2 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl != null ? firebaseUserImpl.getUid() : null), (Object)(firebaseUserImpl2 != null ? firebaseUserImpl2.getUid() : null))) {
                                void $this$forEach$iv;
                                Iterable iterable = FirebaseAuth.access$getAuthStateListeners$p(this.this$0);
                                Iterator<E> iterator = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    AuthStateListener l = (AuthStateListener)element$iv;
                                    boolean bl = false;
                                    l.onAuthStateChanged((FirebaseAuth)((Object)iterator));
                                }
                            }
                            FirebaseUserImpl firebaseUserImpl3 = this.$prev;
                            FirebaseUserImpl firebaseUserImpl4 = this.$value;
                            if (!Intrinsics.areEqual((Object)(firebaseUserImpl3 != null ? firebaseUserImpl3.getIdToken() : null), (Object)(firebaseUserImpl4 != null ? firebaseUserImpl4.getIdToken() : null))) {
                                FirebaseUserImpl firebaseUserImpl5 = this.$value;
                                InternalTokenResult result = new InternalTokenResult(firebaseUserImpl5 != null ? firebaseUserImpl5.getIdToken() : null);
                                for (com.google.firebase.auth.internal.IdTokenListener listener2 : FirebaseAuth.access$getInternalIdTokenListeners$p(this.this$0)) {
                                    FirebaseUserImpl firebaseUserImpl6 = this.$value;
                                    Log.i("FirebaseAuth", "Calling onIdTokenChanged for " + (firebaseUserImpl6 != null ? firebaseUserImpl6.getUid() : null) + " on listener " + listener2);
                                    listener2.onIdTokenChanged(result);
                                }
                                for (IdTokenListener listener3 : FirebaseAuth.access$getIdTokenListeners$p(this.this$0)) {
                                    listener3.onIdTokenChanged(this.this$0);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @NotNull
    public final Task<AuthResult> signInAnonymously() {
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true)))).toString());
        Request request = new Request.Builder().url("https://identitytoolkit.googleapis.com/v1/accounts:signUp?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    Request request = this.$request;
                    Intrinsics.checkNotNullExpressionValue((Object)request, (String)"$request");
                    this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("accounts:signUp", request, response));
                } else {
                    String string;
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    Closeable closeable = (Closeable)responseBody;
                    Throwable throwable = null;
                    try {
                        ResponseBody it = (ResponseBody)closeable;
                        boolean bl = false;
                        string = it.string();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String body = string;
                    FirebaseApp firebaseApp = this.this$0.getApp();
                    Json json = FirebaseAuthKt.getJsonParser();
                    Intrinsics.checkNotNull((Object)body);
                    FirebaseAuth.access$setUser(this.this$0, new FirebaseUserImpl(firebaseApp, JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body)), true));
                    this.$source.setResult(() -> signInAnonymously.1.onResponse$lambda$1(this.this$0));
                }
            }

            private static final FirebaseUser onResponse$lambda$1(FirebaseAuth this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return FirebaseAuth.access$getUser$p(this$0);
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<AuthResult> signInWithCustomToken(@NotNull String customToken) {
        Intrinsics.checkNotNullParameter((Object)customToken, (String)"customToken");
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"token", (Object)JsonElementKt.JsonPrimitive((String)customToken)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url("https://www.googleapis.com/identitytoolkit/v3/relyingparty/verifyCustomToken?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    Request request = this.$request;
                    Intrinsics.checkNotNullExpressionValue((Object)request, (String)"$request");
                    this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("verifyCustomToken", request, response));
                } else {
                    String string;
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    Closeable closeable = (Closeable)responseBody;
                    Throwable throwable = null;
                    try {
                        ResponseBody it = (ResponseBody)closeable;
                        boolean bl = false;
                        string = it.string();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String body = string;
                    FirebaseApp firebaseApp = this.this$0.getApp();
                    Json json = FirebaseAuthKt.getJsonParser();
                    Intrinsics.checkNotNull((Object)body);
                    FirebaseUserImpl user2 = new FirebaseUserImpl(firebaseApp, JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body)), false, 4, null);
                    this.this$0.refreshToken$firebase_java_sdk(user2, this.$source, signInWithCustomToken.onResponse.1.INSTANCE);
                }
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        TaskCompletionSource<AuthResult> source = new TaskCompletionSource<AuthResult>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)JsonElementKt.JsonPrimitive((String)email)), TuplesKt.to((Object)"password", (Object)JsonElementKt.JsonPrimitive((String)password)), TuplesKt.to((Object)"returnSecureToken", (Object)JsonElementKt.JsonPrimitive((Boolean)true))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url("https://www.googleapis.com/identitytoolkit/v3/relyingparty/verifyPassword?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, request){
            final /* synthetic */ TaskCompletionSource<AuthResult> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ Request $request;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    Request request = this.$request;
                    Intrinsics.checkNotNullExpressionValue((Object)request, (String)"$request");
                    this.$source.setException(this.this$0.createAuthInvalidUserException$firebase_java_sdk("verifyPassword", request, response));
                } else {
                    String string;
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    Closeable closeable = (Closeable)responseBody;
                    Throwable throwable = null;
                    try {
                        ResponseBody it = (ResponseBody)closeable;
                        boolean bl = false;
                        string = it.string();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String body = string;
                    FirebaseApp firebaseApp = this.this$0.getApp();
                    Json json = FirebaseAuthKt.getJsonParser();
                    Intrinsics.checkNotNull((Object)body);
                    FirebaseUserImpl user2 = new FirebaseUserImpl(firebaseApp, JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body)), false, 4, null);
                    this.this$0.refreshToken$firebase_java_sdk(user2, this.$source, signInWithEmailAndPassword.onResponse.1.INSTANCE);
                }
            }
        });
        Task<AuthResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FirebaseAuthInvalidUserException createAuthInvalidUserException$firebase_java_sdk(@NotNull String action, @NotNull Request request, @NotNull Response response) {
        String string;
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement;
        String string2;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        Closeable closeable = (Closeable)responseBody;
        Throwable throwable = null;
        try {
            ResponseBody it = (ResponseBody)closeable;
            boolean bl = false;
            string2 = it.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String body = string2;
        Json json = FirebaseAuthKt.getJsonParser();
        Intrinsics.checkNotNull((Object)body);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(body));
        throwable = (JsonElement)jsonObject.get((Object)"error");
        return new FirebaseAuthInvalidUserException(throwable != null && (string2 = JsonElementKt.getJsonObject((JsonElement)throwable)) != null && (jsonElement = (JsonElement)string2.get((Object)"message")) != null && (jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null && (string = JsonElementKt.getContentOrNull((JsonPrimitive)jsonPrimitive)) != null ? string : "UNKNOWN_ERROR", action + " API returned an error, with url [" + request.method() + "] " + request.url() + " " + request.body() + " -- response [" + response.code() + "] " + response.message() + " " + body);
    }

    public final void signOut() {
        this.setUser(null);
    }

    @Override
    @NotNull
    public Task<GetTokenResult> getAccessToken(boolean forceRefresh) {
        FirebaseUserImpl firebaseUserImpl = this.user;
        if (firebaseUserImpl == null) {
            Task<GetTokenResult> task = Tasks.forException(new FirebaseNoSignedInUserException("Please sign in before trying to get a token."));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forException(...)");
            return task;
        }
        FirebaseUserImpl user2 = firebaseUserImpl;
        if (!forceRefresh && user2.getCreatedAt() + (long)(user2.getExpiresIn() * 1000) - (long)300000 > System.currentTimeMillis()) {
            Task<GetTokenResult> task = Tasks.forResult(new GetTokenResult(user2.getIdToken(), user2.getClaims()));
            Intrinsics.checkNotNullExpressionValue(task, (String)"forResult(...)");
            return task;
        }
        TaskCompletionSource source = new TaskCompletionSource();
        this.refreshToken$firebase_java_sdk(user2, source, (Function1)new Function1<FirebaseUserImpl, GetTokenResult>(user2){
            final /* synthetic */ FirebaseUserImpl $user;
            {
                this.$user = $user;
                super(1);
            }

            @Nullable
            public final GetTokenResult invoke(@NotNull FirebaseUserImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new GetTokenResult(it.getIdToken(), this.$user.getClaims());
            }
        });
        Task<GetTokenResult> task = source.getTask();
        Intrinsics.checkNotNullExpressionValue(task, (String)"getTask(...)");
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void refreshToken$firebase_java_sdk(@NotNull FirebaseUserImpl user2, @NotNull TaskCompletionSource<T> source, @NotNull Function1<? super FirebaseUserImpl, ? extends T> map2) {
        void it;
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource;
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource2 = taskCompletionSource = this.refreshSource;
        FirebaseAuth firebaseAuth = this;
        boolean bl = false;
        boolean bl2 = it.getTask().isComplete();
        TaskCompletionSource<FirebaseUserImpl> taskCompletionSource3 = !bl2 ? taskCompletionSource : null;
        if (taskCompletionSource3 == null) {
            taskCompletionSource3 = this.enqueueRefreshTokenCall(user2);
        }
        firebaseAuth.refreshSource = taskCompletionSource3;
        this.refreshSource.getTask().addOnSuccessListener(arg_0 -> FirebaseAuth.refreshToken$lambda$7((Function1)new Function1<FirebaseUserImpl, Unit>(source, map2){
            final /* synthetic */ TaskCompletionSource<T> $source;
            final /* synthetic */ Function1<FirebaseUserImpl, T> $map;
            {
                this.$source = $source;
                this.$map = $map;
                super(1);
            }

            public final void invoke(FirebaseUserImpl it) {
                Intrinsics.checkNotNull((Object)it);
                this.$source.setResult(this.$map.invoke((Object)it));
            }
        }, arg_0));
        this.refreshSource.getTask().addOnFailureListener(arg_0 -> FirebaseAuth.refreshToken$lambda$8(source, arg_0));
    }

    private final TaskCompletionSource<FirebaseUserImpl> enqueueRefreshTokenCall(FirebaseUserImpl user2) {
        TaskCompletionSource<FirebaseUserImpl> source = new TaskCompletionSource<FirebaseUserImpl>();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"refresh_token", (Object)JsonElementKt.JsonPrimitive((String)user2.getRefreshToken())), TuplesKt.to((Object)"grant_type", (Object)JsonElementKt.JsonPrimitive((String)"refresh_token"))};
        RequestBody body = RequestBody.create((MediaType)this.json, (String)new JsonObject(MapsKt.mapOf((Pair[])pairArray)).toString());
        Request request = new Request.Builder().url("https://securetoken.googleapis.com/v1/token?key=" + this.app.getOptions().getApiKey()).post(body).build();
        this.client.newCall(request).enqueue(new Callback(source, this, user2){
            final /* synthetic */ TaskCompletionSource<FirebaseUserImpl> $source;
            final /* synthetic */ FirebaseAuth this$0;
            final /* synthetic */ FirebaseUserImpl $user;
            {
                this.$source = $source;
                this.this$0 = $receiver;
                this.$user = $user;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$source.setException(new FirebaseException(e.toString(), e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                String body;
                Object object;
                Object object2;
                Object object3;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    object3 = (Closeable)responseBody;
                    object2 = null;
                    try {
                        ResponseBody it = (ResponseBody)object3;
                        boolean bl = false;
                        object = it.string();
                        v1 = object;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                    }
                } else {
                    v1 = body = null;
                }
                if (!response.isSuccessful()) {
                    String string = body;
                    if (string == null) {
                        string = "";
                    }
                    this.signOutAndThrowInvalidUserException(string, "token API returned an error: " + body);
                } else {
                    Json json = FirebaseAuthKt.getJsonParser();
                    String string = body;
                    Intrinsics.checkNotNull(string);
                    JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(string));
                    object3 = this.this$0;
                    object2 = this.$user;
                    object = this.$source;
                    JsonObject $this$onResponse_u24lambda_u241 = jsonObject;
                    boolean bl = false;
                    FirebaseUserImpl user2 = new FirebaseUserImpl(((FirebaseAuth)object3).getApp(), $this$onResponse_u24lambda_u241, ((FirebaseUserImpl)object2).isAnonymous());
                    if (!Intrinsics.areEqual((Object)user2.getClaims().get("aud"), (Object)((FirebaseAuth)object3).getApp().getOptions().getProjectId())) {
                        this.signOutAndThrowInvalidUserException(user2.getClaims().toString(), "Project ID's do not match " + user2.getClaims().get("aud") + " != " + ((FirebaseAuth)object3).getApp().getOptions().getProjectId());
                    } else {
                        FirebaseAuth.access$setUser((FirebaseAuth)object3, user2);
                        ((TaskCompletionSource)object).setResult(user2);
                    }
                }
            }

            private final void signOutAndThrowInvalidUserException(String body, String message) {
                this.this$0.signOut();
                this.$source.setException(new FirebaseAuthInvalidUserException(body, message));
            }
        });
        return source;
    }

    @Override
    @Nullable
    public String getUid() {
        FirebaseUserImpl firebaseUserImpl = this.user;
        return firebaseUserImpl != null ? firebaseUserImpl.getUid() : null;
    }

    @Override
    public void addIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.internalIdTokenListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ com.google.firebase.auth.internal.IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FirebaseUserImpl firebaseUserImpl = FirebaseAuth.access$getUser$p(this.this$0);
                        this.$listener.onIdTokenChanged(new InternalTokenResult(firebaseUserImpl != null ? firebaseUserImpl.getIdToken() : null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void removeIdTokenListener(@NotNull com.google.firebase.auth.internal.IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.internalIdTokenListeners.remove(listener2);
    }

    public final synchronized void addAuthStateListener(@NotNull AuthStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.authStateListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ AuthStateListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onAuthStateChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final synchronized void removeAuthStateListener(@NotNull AuthStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.authStateListeners.remove(listener2);
    }

    public final void addIdTokenListener(@NotNull IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.idTokenListeners.addIfAbsent(listener2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, null){
            int label;
            final /* synthetic */ IdTokenListener $listener;
            final /* synthetic */ FirebaseAuth this$0;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.onIdTokenChanged(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void removeIdTokenListener(@NotNull IdTokenListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.idTokenListeners.remove(listener2);
    }

    @NotNull
    public final Task<Unit> sendPasswordResetEmail(@NotNull String email, @Nullable ActionCodeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> createUserWithEmailAndPassword(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithCredential(@NotNull AuthCredential authCredential) {
        Intrinsics.checkNotNullParameter((Object)authCredential, (String)"authCredential");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<ActionCodeResult> checkActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> confirmPasswordReset(@NotNull String code, @NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> sendSignInLinkToEmail(@NotNull String email, @NotNull ActionCodeSettings actionCodeSettings) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)actionCodeSettings, (String)"actionCodeSettings");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<String> verifyPasswordResetCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> updateCurrentUser(@NotNull FirebaseUser user2) {
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<Unit> applyActionCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String getLanguageCode() {
        throw new NotImplementedError(null, 1, null);
    }

    public final boolean isSignInWithEmailLink(@NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Task<AuthResult> signInWithEmailLink(@NotNull String email, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Void setLanguageCode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new NotImplementedError(null, 1, null);
    }

    public final void useEmulator(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        throw new NotImplementedError(null, 1, null);
    }

    private static final void refreshToken$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void refreshToken$lambda$8(TaskCompletionSource $source, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $source.setException(it);
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
        return Companion.getInstance(app);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getAuthStateListeners$p(FirebaseAuth $this) {
        return $this.authStateListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getInternalIdTokenListeners$p(FirebaseAuth $this) {
        return $this.internalIdTokenListeners;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getIdTokenListeners$p(FirebaseAuth $this) {
        return $this.idTokenListeners;
    }

    public static final /* synthetic */ void access$setUser(FirebaseAuth $this, FirebaseUserImpl value) {
        $this.setUser(value);
    }

    public static final /* synthetic */ FirebaseUserImpl access$getUser$p(FirebaseAuth $this) {
        return $this.user;
    }

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$AuthStateListener;", "", "onAuthStateChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface AuthStateListener {
        public void onAuthStateChanged(@NotNull FirebaseAuth var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$Companion;", "", "()V", "getInstance", "Lcom/google/firebase/auth/FirebaseAuth;", "app", "Lcom/google/firebase/FirebaseApp;", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance() {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)firebaseApp, (String)"getInstance(...)");
            return this.getInstance(firebaseApp);
        }

        @JvmStatic
        @NotNull
        public final FirebaseAuth getInstance(@NotNull FirebaseApp app) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            FirebaseAuth firebaseAuth = app.get(FirebaseAuth.class);
            Intrinsics.checkNotNullExpressionValue((Object)firebaseAuth, (String)"get(...)");
            return firebaseAuth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/auth/FirebaseAuth$IdTokenListener;", "", "onIdTokenChanged", "", "auth", "Lcom/google/firebase/auth/FirebaseAuth;", "firebase-java-sdk"})
    public static interface IdTokenListener {
        public void onIdTokenChanged(@NotNull FirebaseAuth var1);
    }
}

