/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u000bJ\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;", "", "createTableStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "viewLookup", "", "", "resolvedAnnotations", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "getFieldAnnotations", "tableName", "fieldName", "findView", "viewName", "buildResolvedAnnotations", "hasAnyAnnotations", "", "annotations", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFieldAnnotationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldAnnotationResolver.kt\ndev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1202#2,2:89\n1230#2,4:91\n1863#2:95\n1863#2,2:96\n1864#2:98\n1863#2:99\n1863#2,2:100\n1864#2:102\n*S KotlinDebug\n*F\n+ 1 FieldAnnotationResolver.kt\ndev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver\n*L\n15#1:89,2\n15#1:91,4\n50#1:95\n51#1:96,2\n50#1:98\n61#1:99\n62#1:100,2\n61#1:102\n*E\n"})
public final class FieldAnnotationResolver {
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final List<AnnotatedCreateViewStatement> createViewStatements;
    @NotNull
    private final Map<String, AnnotatedCreateViewStatement> viewLookup;
    @NotNull
    private final Map<String, FieldAnnotationOverrides> resolvedAnnotations;

    /*
     * WARNING - void declaration
     */
    public FieldAnnotationResolver(@NotNull List<AnnotatedCreateTableStatement> createTableStatements, @NotNull List<AnnotatedCreateViewStatement> createViewStatements) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        Intrinsics.checkNotNullParameter(createViewStatements, (String)"createViewStatements");
        this.createTableStatements = createTableStatements;
        this.createViewStatements = createViewStatements;
        Iterable iterable = this.createViewStatements;
        FieldAnnotationResolver fieldAnnotationResolver = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AnnotatedCreateViewStatement annotatedCreateViewStatement = (AnnotatedCreateViewStatement)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getSrc().getViewName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, element$iv$iv);
        }
        fieldAnnotationResolver.viewLookup = destination$iv$iv;
        this.resolvedAnnotations = this.buildResolvedAnnotations();
    }

    @Nullable
    public final FieldAnnotationOverrides getFieldAnnotations(@NotNull String tableName, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        String key = tableName + "." + fieldName;
        return this.resolvedAnnotations.get(key);
    }

    @Nullable
    public final AnnotatedCreateViewStatement findView(@NotNull String viewName) {
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        String string = viewName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.viewLookup.get(string);
    }

    private final Map<String, FieldAnnotationOverrides> buildResolvedAnnotations() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Map annotations = new LinkedHashMap();
        Iterable $this$forEach$iv2 = this.createTableStatements;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AnnotatedCreateTableStatement table = (AnnotatedCreateTableStatement)element$iv;
            boolean bl = false;
            $this$forEach$iv = table.getColumns();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv2;
                boolean bl2 = false;
                FieldAnnotationOverrides fieldAnnotations = FieldAnnotationOverrides.Companion.parse(column.getAnnotations());
                if (!this.hasAnyAnnotations(fieldAnnotations)) continue;
                String key = table.getName() + "." + column.getSrc().getName();
                annotations.put(key, fieldAnnotations);
            }
        }
        $this$forEach$iv2 = this.createViewStatements;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AnnotatedCreateViewStatement view = (AnnotatedCreateViewStatement)element$iv;
            boolean bl = false;
            $this$forEach$iv = view.getFields();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AnnotatedCreateViewStatement.Field field = (AnnotatedCreateViewStatement.Field)element$iv2;
                boolean bl3 = false;
                if (!this.hasAnyAnnotations(field.getAnnotations())) continue;
                String key = view.getSrc().getViewName() + "." + field.getSrc().getFieldName();
                annotations.put(key, field.getAnnotations());
            }
        }
        return annotations;
    }

    private final boolean hasAnyAnnotations(FieldAnnotationOverrides annotations) {
        return annotations.getPropertyName() != null || annotations.getPropertyType() != null || Intrinsics.areEqual((Object)annotations.getAdapter(), (Object)true) || annotations.getNotNull() != null || annotations.isDynamicField() || annotations.getDefaultValue() != null || annotations.getAliasPrefix() != null || annotations.getMappingType() != null || annotations.getSourceTable() != null;
    }
}

