/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser;

import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.parser.NodeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseNodeParser
implements NodeParser {
    private static final JSONObject EMPTY_JSON_OBJECT = new JSONObject(Collections.emptyMap());

    public JSONObject getData(JSONObject nodeObject) {
        JSONObject jsonObject = nodeObject.getJSONObject("data");
        return jsonObject != null ? jsonObject : EMPTY_JSON_OBJECT;
    }

    public void addParameters(BaseNode node, JSONObject data) {
        List<Parameter> inputParameters = this.getParameters(data, "parameters");
        node.setParameters(inputParameters);
    }

    public List<Parameter> getParameters(JSONObject data, String key) {
        JSONArray parametersJsonArray = data.getJSONArray(key);
        if (parametersJsonArray == null || parametersJsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parametersJsonArray.size());
        for (int i = 0; i < parametersJsonArray.size(); ++i) {
            JSONObject inputParam = parametersJsonArray.getJSONObject(i);
            Parameter parameter = new Parameter();
            parameter.setName(inputParam.getString("name"));
            parameter.setDescription(inputParam.getString("description"));
            parameter.setRef(inputParam.getString("ref"));
            parameter.setRefType(RefType.ofValue((String)inputParam.getString("refType")));
            parameter.setDataType(DataType.ofValue((String)inputParam.getString("dataType")));
            parameter.setRequired(inputParam.getBooleanValue("required"));
            parameters.add(parameter);
        }
        return parameters;
    }

    public void addOutputKeys(BaseNode node, JSONObject data) {
        JSONArray outputParams = data.getJSONArray("outputDefs");
        if (outputParams != null) {
            for (int i = 0; i < outputParams.size(); ++i) {
                JSONObject outputParam = outputParams.getJSONObject(i);
                Parameter outputDef = new Parameter();
                outputDef.setName(outputParam.getString("name"));
                outputDef.setDescription(outputParam.getString("description"));
                outputDef.setRef(outputParam.getString("ref"));
                outputDef.setRefType(RefType.ofValue((String)outputParam.getString("refType")));
                outputDef.setDataType(DataType.ofValue((String)outputParam.getString("dataType")));
                node.addOutputDef(outputDef);
            }
        }
    }
}

