/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser.impl;

import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.chain.node.LlmNode;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.Tinyflow;
import dev.tinyflow.core.parser.BaseNodeParser;
import dev.tinyflow.core.provder.LlmProvider;

public class LlmNodeParser
extends BaseNodeParser {
    @Override
    public ChainNode parse(JSONObject nodeJSONObject, Tinyflow tinyflow) {
        LlmNode llmNode = new LlmNode();
        JSONObject data = this.getData(nodeJSONObject);
        llmNode.setName(data.getString("label"));
        llmNode.setUserPrompt(data.getString("userPrompt"));
        llmNode.setSystemPrompt(data.getString("systemPrompt"));
        llmNode.setOutType(data.getString("outType"));
        ChatOptions chatOptions = new ChatOptions();
        chatOptions.setTopK(data.getInteger("topK"));
        chatOptions.setTopP(data.getFloat("topP"));
        chatOptions.setTemperature(data.getFloat("temperature"));
        llmNode.setChatOptions(chatOptions);
        LlmProvider llmProvider = tinyflow.getLlmProvider();
        if (llmProvider != null) {
            Llm llm = llmProvider.getLlm(data.getBigInteger("model"));
            llmNode.setLlm(llm);
        }
        this.addParameters((BaseNode)llmNode, data);
        this.addOutputKeys((BaseNode)llmNode, data);
        return llmNode;
    }
}

